%------------------------------------------------------------------------------
% File     : ITP013^7 : TPTP v9.2.0. Bugfixed v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : HOL4 syntactic export of thm_2Ewords_2En2w__sub.p, chainy mode
% Version  : [BG+19] axioms.
% English  :

% Refs     : [BG+19] Brown et al. (2019), GRUNGE: A Grand Unified ATP Chall
%          : [Gau20] Gauthier (2020), Email to Geoff Sutcliffe
% Source   : [BG+19]
% Names    : thm_2Ewords_2En2w__sub.p [Gau20]
%          : HL406001^7.p [TPAP]

% Status   : Theorem
% Rating   : 0.67 v9.0.0, 0.33 v8.1.0, 0.75 v7.5.0
% Syntax   : Number of formulae    : 12888 (3194 unt;4483 typ;   0 def)
%            Number of atoms       : 33618 (11502 equ;1389 cnn)
%            Maximal formula atoms :  912 (   3 avg)
%            Number of connectives : 217288 (1389   ~; 736   |;8041   &;198260   @)
%                                         (4100 <=>;4762  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  364 (   8 avg)
%            Number of types       :   11 (  10 usr)
%            Number of type conns  : 24382 (24382   >;   0   *;   0   +;   0  <<)
%            Number of symbols     : 1302 (1300 usr;  23 con; 0-10 aty)
%            Number of variables   : 52399 (3094   ^;32328   !;13262   ?;52399   :)
%                                         (3715  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments :
% Bugfixes : v7.5.0 - Bugfixes in axioms and export.
%------------------------------------------------------------------------------
include('Axioms/ITP001/ITP002^7.ax').
include('Axioms/ITP001/ITP003^7.ax').
include('Axioms/ITP001/ITP004^7.ax').
include('Axioms/ITP001/ITP005^7.ax').
include('Axioms/ITP001/ITP006^7.ax').
include('Axioms/ITP001/ITP007^7.ax').
include('Axioms/ITP001/ITP008^7.ax').
include('Axioms/ITP001/ITP009^7.ax').
include('Axioms/ITP001/ITP010^7.ax').
include('Axioms/ITP001/ITP011^7.ax').
include('Axioms/ITP001/ITP012^7.ax').
include('Axioms/ITP001/ITP013^7.ax').
include('Axioms/ITP001/ITP014^7.ax').
include('Axioms/ITP001/ITP015^7.ax').
include('Axioms/ITP001/ITP016^7.ax').
include('Axioms/ITP001/ITP017^7.ax').
include('Axioms/ITP001/ITP018^7.ax').
include('Axioms/ITP001/ITP019^7.ax').
include('Axioms/ITP001/ITP020^7.ax').
include('Axioms/ITP001/ITP021^7.ax').
include('Axioms/ITP001/ITP022^7.ax').
include('Axioms/ITP001/ITP023^7.ax').
include('Axioms/ITP001/ITP024^7.ax').
include('Axioms/ITP001/ITP025^7.ax').
include('Axioms/ITP001/ITP026^7.ax').
include('Axioms/ITP001/ITP027^7.ax').
include('Axioms/ITP001/ITP028^7.ax').
include('Axioms/ITP001/ITP029^7.ax').
include('Axioms/ITP001/ITP030^7.ax').
include('Axioms/ITP001/ITP031^7.ax').
include('Axioms/ITP001/ITP032^7.ax').
include('Axioms/ITP001/ITP033^7.ax').
include('Axioms/ITP001/ITP034^7.ax').
include('Axioms/ITP001/ITP035^7.ax').
include('Axioms/ITP001/ITP036^7.ax').
include('Axioms/ITP001/ITP037^7.ax').
include('Axioms/ITP001/ITP038^7.ax').
include('Axioms/ITP001/ITP039^7.ax').
include('Axioms/ITP001/ITP040^7.ax').
include('Axioms/ITP001/ITP041^7.ax').
include('Axioms/ITP001/ITP042^7.ax').
include('Axioms/ITP001/ITP043^7.ax').
include('Axioms/ITP001/ITP044^7.ax').
include('Axioms/ITP001/ITP045^7.ax').
include('Axioms/ITP001/ITP046^7.ax').
include('Axioms/ITP001/ITP047^7.ax').
include('Axioms/ITP001/ITP048^7.ax').
include('Axioms/ITP001/ITP049^7.ax').
include('Axioms/ITP001/ITP050^7.ax').
include('Axioms/ITP001/ITP051^7.ax').
include('Axioms/ITP001/ITP052^7.ax').
include('Axioms/ITP001/ITP053^7.ax').
include('Axioms/ITP001/ITP054^7.ax').
include('Axioms/ITP001/ITP055^7.ax').
include('Axioms/ITP001/ITP056^7.ax').
include('Axioms/ITP001/ITP057^7.ax').
include('Axioms/ITP001/ITP058^7.ax').
include('Axioms/ITP001/ITP059^7.ax').
include('Axioms/ITP001/ITP060^7.ax').
include('Axioms/ITP001/ITP061^7.ax').
include('Axioms/ITP001/ITP062^7.ax').
include('Axioms/ITP001/ITP063^7.ax').
include('Axioms/ITP001/ITP064^7.ax').
include('Axioms/ITP001/ITP065^7.ax').
include('Axioms/ITP001/ITP066^7.ax').
include('Axioms/ITP001/ITP067^7.ax').
include('Axioms/ITP001/ITP068^7.ax').
include('Axioms/ITP001/ITP069^7.ax').
include('Axioms/ITP001/ITP070^7.ax').
include('Axioms/ITP001/ITP071^7.ax').
include('Axioms/ITP001/ITP072^7.ax').
include('Axioms/ITP001/ITP073^7.ax').
include('Axioms/ITP001/ITP074^7.ax').
include('Axioms/ITP001/ITP075^7.ax').
include('Axioms/ITP001/ITP076^7.ax').
include('Axioms/ITP001/ITP077^7.ax').
include('Axioms/ITP001/ITP078^7.ax').
include('Axioms/ITP001/ITP079^7.ax').
include('Axioms/ITP001/ITP080^7.ax').
include('Axioms/ITP001/ITP081^7.ax').
include('Axioms/ITP001/ITP082^7.ax').
include('Axioms/ITP001/ITP083^7.ax').
include('Axioms/ITP001/ITP084^7.ax').
include('Axioms/ITP001/ITP085^7.ax').
include('Axioms/ITP001/ITP086^7.ax').
include('Axioms/ITP001/ITP087^7.ax').
include('Axioms/ITP001/ITP088^7.ax').
include('Axioms/ITP001/ITP089^7.ax').
%------------------------------------------------------------------------------
thf(tyop_2Ebool_2Eitself,type,
    tyop_2Ebool_2Eitself: $tType > $tType ).

thf(tyop_2Efcp_2Ecart,type,
    tyop_2Efcp_2Ecart: $tType > $tType > $tType ).

thf(tyop_2Elist_2Elist,type,
    tyop_2Elist_2Elist: $tType > $tType ).

thf(tyop_2Emin_2Ebool,type,
    tyop_2Emin_2Ebool: $tType ).

thf(tyop_2Emin_2Efun,type,
    tyop_2Emin_2Efun: $tType > $tType > $tType ).

thf(tyop_2Enum_2Enum,type,
    tyop_2Enum_2Enum: $tType ).

thf(tyop_2Eone_2Eone,type,
    tyop_2Eone_2Eone: $tType ).

thf(tyop_2Epair_2Eprod,type,
    tyop_2Epair_2Eprod: $tType > $tType > $tType ).

thf(tyop_2Estring_2Echar,type,
    tyop_2Estring_2Echar: $tType ).

thf(tyop_2Esum_2Esum,type,
    tyop_2Esum_2Esum: $tType > $tType > $tType ).

thf(c_2Ebool_2E_21,type,
    c_2Ebool_2E_21: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > $o ) ).

thf(c_2Earithmetic_2E_2A,type,
    c_2Earithmetic_2E_2A: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Earithmetic_2E_2B,type,
    c_2Earithmetic_2E_2B: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Epair_2E_2C,type,
    c_2Epair_2E_2C: 
      !>[A_27a: $tType,A_27b: $tType] : ( A_27a > A_27b > ( tyop_2Epair_2Eprod @ A_27a @ A_27b ) ) ).

thf(c_2Earithmetic_2E_2D,type,
    c_2Earithmetic_2E_2D: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ebool_2E_2F_5C,type,
    c_2Ebool_2E_2F_5C: $o > $o > $o ).

thf(c_2Enum_2E0,type,
    c_2Enum_2E0: tyop_2Enum_2Enum ).

thf(c_2Efcp_2E_3A_2B,type,
    c_2Efcp_2E_3A_2B: 
      !>[A_27a: $tType,A_27b: $tType] : ( tyop_2Enum_2Enum > A_27a > ( tyop_2Efcp_2Ecart @ A_27a @ A_27b ) > ( tyop_2Efcp_2Ecart @ A_27a @ A_27b ) ) ).

thf(c_2Eprim__rec_2E_3C,type,
    c_2Eprim__rec_2E_3C: tyop_2Enum_2Enum > tyop_2Enum_2Enum > $o ).

thf(c_2Earithmetic_2E_3C_3D,type,
    c_2Earithmetic_2E_3C_3D: tyop_2Enum_2Enum > tyop_2Enum_2Enum > $o ).

thf(c_2Emin_2E_3D,type,
    c_2Emin_2E_3D: 
      !>[A_27a: $tType] : ( A_27a > A_27a > $o ) ).

thf(c_2Emin_2E_3D_3D_3E,type,
    c_2Emin_2E_3D_3D_3E: $o > $o > $o ).

thf(c_2Ebool_2E_3F,type,
    c_2Ebool_2E_3F: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > $o ) ).

thf(c_2Ebit_2EBIT,type,
    c_2Ebit_2EBIT: tyop_2Enum_2Enum > tyop_2Enum_2Enum > $o ).

thf(c_2Earithmetic_2EBIT1,type,
    c_2Earithmetic_2EBIT1: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Earithmetic_2EBIT2,type,
    c_2Earithmetic_2EBIT2: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ebit_2EBITS,type,
    c_2Ebit_2EBITS: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ebit_2EBITWISE,type,
    c_2Ebit_2EBITWISE: tyop_2Enum_2Enum > ( $o > $o > $o ) > tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ebit_2EBIT__MODIFY,type,
    c_2Ebit_2EBIT__MODIFY: tyop_2Enum_2Enum > ( tyop_2Enum_2Enum > $o > $o ) > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ebit_2EBIT__REVERSE,type,
    c_2Ebit_2EBIT__REVERSE: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ewords_2EBIT__SET,type,
    c_2Ewords_2EBIT__SET: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum > $o ).

thf(c_2Enumposrep_2EBOOLIFY,type,
    c_2Enumposrep_2EBOOLIFY: tyop_2Enum_2Enum > tyop_2Enum_2Enum > ( tyop_2Elist_2Elist @ $o ) > ( tyop_2Elist_2Elist @ $o ) ).

thf(c_2Ebool_2ECOND,type,
    c_2Ebool_2ECOND: 
      !>[A_27a: $tType] : ( $o > A_27a > A_27a > A_27a ) ).

thf(c_2Elist_2ECONS,type,
    c_2Elist_2ECONS: 
      !>[A_27a: $tType] : ( A_27a > ( tyop_2Elist_2Elist @ A_27a ) > ( tyop_2Elist_2Elist @ A_27a ) ) ).

thf(c_2Earithmetic_2EDIV,type,
    c_2Earithmetic_2EDIV: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Epred__set_2EEMPTY,type,
    c_2Epred__set_2EEMPTY: 
      !>[A_27a: $tType] : ( A_27a > $o ) ).

thf(c_2Earithmetic_2EEXP,type,
    c_2Earithmetic_2EEXP: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ebool_2EF,type,
    c_2Ebool_2EF: $o ).

thf(c_2Ecombin_2EFAIL,type,
    c_2Ecombin_2EFAIL: 
      !>[A_27a: $tType,A_27b: $tType] : ( A_27a > A_27b > A_27a ) ).

thf(c_2Efcp_2EFCP,type,
    c_2Efcp_2EFCP: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( tyop_2Enum_2Enum > A_27a ) > ( tyop_2Efcp_2Ecart @ A_27a @ A_27b ) ) ).

thf(c_2Epred__set_2EFINITE,type,
    c_2Epred__set_2EFINITE: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > $o ) ).

thf(c_2Elist_2EFOLDL,type,
    c_2Elist_2EFOLDL: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27b > A_27a > A_27b ) > A_27b > ( tyop_2Elist_2Elist @ A_27a ) > A_27b ) ).

thf(c_2Elist_2EGENLIST,type,
    c_2Elist_2EGENLIST: 
      !>[A_27a: $tType] : ( ( tyop_2Enum_2Enum > A_27a ) > tyop_2Enum_2Enum > ( tyop_2Elist_2Elist @ A_27a ) ) ).

thf(c_2Elist_2EHD,type,
    c_2Elist_2EHD: 
      !>[A_27a: $tType] : ( ( tyop_2Elist_2Elist @ A_27a ) > A_27a ) ).

thf(c_2EASCIInumbers_2EHEX,type,
    c_2EASCIInumbers_2EHEX: tyop_2Enum_2Enum > tyop_2Estring_2Echar ).

thf(c_2Ecombin_2EI,type,
    c_2Ecombin_2EI: 
      !>[A_27a: $tType] : ( A_27a > A_27a ) ).

thf(c_2Ebool_2EIN,type,
    c_2Ebool_2EIN: 
      !>[A_27a: $tType] : ( A_27a > ( A_27a > $o ) > $o ) ).

thf(c_2Epred__set_2EINSERT,type,
    c_2Epred__set_2EINSERT: 
      !>[A_27a: $tType] : ( A_27a > ( A_27a > $o ) > A_27a > $o ) ).

thf(c_2Ewords_2EINT__MAX,type,
    c_2Ewords_2EINT__MAX: 
      !>[A_27a: $tType] : ( ( tyop_2Ebool_2Eitself @ A_27a ) > tyop_2Enum_2Enum ) ).

thf(c_2Ewords_2EINT__MIN,type,
    c_2Ewords_2EINT__MIN: 
      !>[A_27a: $tType] : ( ( tyop_2Ebool_2Eitself @ A_27a ) > tyop_2Enum_2Enum ) ).

thf(c_2Ecombin_2EK,type,
    c_2Ecombin_2EK: 
      !>[A_27a: $tType,A_27b: $tType] : ( A_27a > A_27b > A_27a ) ).

thf(c_2Ewhile_2ELEAST,type,
    c_2Ewhile_2ELEAST: ( tyop_2Enum_2Enum > $o ) > tyop_2Enum_2Enum ).

thf(c_2Ebool_2ELET,type,
    c_2Ebool_2ELET: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a > A_27b ) > A_27a > A_27b ) ).

thf(c_2Ebit_2ELOG2,type,
    c_2Ebit_2ELOG2: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Earithmetic_2EMAX,type,
    c_2Earithmetic_2EMAX: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Earithmetic_2EMIN,type,
    c_2Earithmetic_2EMIN: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Earithmetic_2EMOD,type,
    c_2Earithmetic_2EMOD: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ebit_2EMOD__2EXP,type,
    c_2Ebit_2EMOD__2EXP: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Elist_2ENIL,type,
    c_2Elist_2ENIL: 
      !>[A_27a: $tType] : ( tyop_2Elist_2Elist @ A_27a ) ).

thf(c_2Earithmetic_2ENUMERAL,type,
    c_2Earithmetic_2ENUMERAL: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Earithmetic_2EODD,type,
    c_2Earithmetic_2EODD: tyop_2Enum_2Enum > $o ).

thf(c_2Ebit_2ESBIT,type,
    c_2Ebit_2ESBIT: $o > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ebit_2ESIGN__EXTEND,type,
    c_2Ebit_2ESIGN__EXTEND: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ebit_2ESLICE,type,
    c_2Ebit_2ESLICE: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Enum_2ESUC,type,
    c_2Enum_2ESUC: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Esum__num_2ESUM,type,
    c_2Esum__num_2ESUM: tyop_2Enum_2Enum > ( tyop_2Enum_2Enum > tyop_2Enum_2Enum ) > tyop_2Enum_2Enum ).

thf(c_2Ebool_2ET,type,
    c_2Ebool_2ET: $o ).

thf(c_2Elist_2ETL,type,
    c_2Elist_2ETL: 
      !>[A_27a: $tType] : ( ( tyop_2Elist_2Elist @ A_27a ) > ( tyop_2Elist_2Elist @ A_27a ) ) ).

thf(c_2Ewords_2EUINT__MAX,type,
    c_2Ewords_2EUINT__MAX: 
      !>[A_27a: $tType] : ( ( tyop_2Ebool_2Eitself @ A_27a ) > tyop_2Enum_2Enum ) ).

thf(c_2Epair_2EUNCURRY,type,
    c_2Epair_2EUNCURRY: 
      !>[A_27a: $tType,A_27b: $tType,A_27c: $tType] : ( ( A_27a > A_27b > A_27c ) > ( tyop_2Epair_2Eprod @ A_27a @ A_27b ) > A_27c ) ).

thf(c_2EASCIInumbers_2EUNHEX,type,
    c_2EASCIInumbers_2EUNHEX: tyop_2Estring_2Echar > tyop_2Enum_2Enum ).

thf(c_2Epred__set_2EUNIV,type,
    c_2Epred__set_2EUNIV: 
      !>[A_27a: $tType] : ( A_27a > $o ) ).

thf(c_2Earithmetic_2EZERO,type,
    c_2Earithmetic_2EZERO: tyop_2Enum_2Enum ).

thf(c_2Ebool_2E_5C_2F,type,
    c_2Ebool_2E_5C_2F: $o > $o > $o ).

thf(c_2Ewords_2Eadd__with__carry,type,
    c_2Ewords_2Eadd__with__carry: 
      !>[A_27a: $tType] : ( ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ $o ) ) > ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) ).

thf(c_2Ewords_2Ebit__count,type,
    c_2Ewords_2Ebit__count: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > tyop_2Enum_2Enum ) ).

thf(c_2Ewords_2Ebit__count__upto,type,
    c_2Ewords_2Ebit__count__upto: 
      !>[A_27a: $tType] : ( tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > tyop_2Enum_2Enum ) ).

thf(c_2Ewords_2Ebit__field__insert,type,
    c_2Ewords_2Ebit__field__insert: 
      !>[A_27a: $tType,A_27b: $tType] : ( tyop_2Enum_2Enum > tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27b ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Econcat__word__list,type,
    c_2Ewords_2Econcat__word__list: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( tyop_2Elist_2Elist @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) > ( tyop_2Efcp_2Ecart @ $o @ A_27b ) ) ).

thf(c_2Efcp_2Edimindex,type,
    c_2Efcp_2Edimindex: 
      !>[A_27a: $tType] : ( ( tyop_2Ebool_2Eitself @ A_27a ) > tyop_2Enum_2Enum ) ).

thf(c_2Ewords_2Edimword,type,
    c_2Ewords_2Edimword: 
      !>[A_27a: $tType] : ( ( tyop_2Ebool_2Eitself @ A_27a ) > tyop_2Enum_2Enum ) ).

thf(c_2Efcp_2Efcp__index,type,
    c_2Efcp_2Efcp__index: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( tyop_2Efcp_2Ecart @ A_27a @ A_27b ) > tyop_2Enum_2Enum > A_27a ) ).

thf(c_2Enumposrep_2El2n,type,
    c_2Enumposrep_2El2n: tyop_2Enum_2Enum > ( tyop_2Elist_2Elist @ tyop_2Enum_2Enum ) > tyop_2Enum_2Enum ).

thf(c_2Ewords_2El2w,type,
    c_2Ewords_2El2w: 
      !>[A_27a: $tType] : ( tyop_2Enum_2Enum > ( tyop_2Elist_2Elist @ tyop_2Enum_2Enum ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Enumposrep_2En2l,type,
    c_2Enumposrep_2En2l: tyop_2Enum_2Enum > tyop_2Enum_2Enum > ( tyop_2Elist_2Elist @ tyop_2Enum_2Enum ) ).

thf(c_2EASCIInumbers_2En2s,type,
    c_2EASCIInumbers_2En2s: tyop_2Enum_2Enum > ( tyop_2Enum_2Enum > tyop_2Estring_2Echar ) > tyop_2Enum_2Enum > ( tyop_2Elist_2Elist @ tyop_2Estring_2Echar ) ).

thf(c_2Ewords_2En2w,type,
    c_2Ewords_2En2w: 
      !>[A_27a: $tType] : ( tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Enzcv,type,
    c_2Ewords_2Enzcv: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) ) ).

thf(c_2Ecombin_2Eo,type,
    c_2Ecombin_2Eo: 
      !>[A_27a: $tType,A_27b: $tType,A_27c: $tType] : ( ( A_27c > A_27b ) > ( A_27a > A_27c ) > A_27a > A_27b ) ).

thf(c_2Ewords_2Ereduce__and,type,
    c_2Ewords_2Ereduce__and: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) ) ).

thf(c_2Ewords_2Ereduce__nand,type,
    c_2Ewords_2Ereduce__nand: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) ) ).

thf(c_2Ewords_2Ereduce__nor,type,
    c_2Ewords_2Ereduce__nor: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) ) ).

thf(c_2Ewords_2Ereduce__or,type,
    c_2Ewords_2Ereduce__or: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) ) ).

thf(c_2Ewords_2Ereduce__xnor,type,
    c_2Ewords_2Ereduce__xnor: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) ) ).

thf(c_2Ewords_2Ereduce__xor,type,
    c_2Ewords_2Ereduce__xor: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) ) ).

thf(c_2EASCIInumbers_2Es2n,type,
    c_2EASCIInumbers_2Es2n: tyop_2Enum_2Enum > ( tyop_2Estring_2Echar > tyop_2Enum_2Enum ) > ( tyop_2Elist_2Elist @ tyop_2Estring_2Echar ) > tyop_2Enum_2Enum ).

thf(c_2Ewords_2Es2w,type,
    c_2Ewords_2Es2w: 
      !>[A_27a: $tType] : ( tyop_2Enum_2Enum > ( tyop_2Estring_2Echar > tyop_2Enum_2Enum ) > ( tyop_2Elist_2Elist @ tyop_2Estring_2Echar ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Esaturate__add,type,
    c_2Ewords_2Esaturate__add: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Esaturate__mul,type,
    c_2Ewords_2Esaturate__mul: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Esaturate__n2w,type,
    c_2Ewords_2Esaturate__n2w: 
      !>[A_27a: $tType] : ( tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Esaturate__sub,type,
    c_2Ewords_2Esaturate__sub: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Esaturate__w2w,type,
    c_2Ewords_2Esaturate__w2w: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27b ) ) ).

thf(c_2Ewords_2Esw2sw,type,
    c_2Ewords_2Esw2sw: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27b ) ) ).

thf(c_2Ebool_2Ethe__value,type,
    c_2Ebool_2Ethe__value: 
      !>[A_27a: $tType] : ( tyop_2Ebool_2Eitself @ A_27a ) ).

thf(c_2Ewords_2Ew2l,type,
    c_2Ewords_2Ew2l: 
      !>[A_27a: $tType] : ( tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Elist_2Elist @ tyop_2Enum_2Enum ) ) ).

thf(c_2Ewords_2Ew2n,type,
    c_2Ewords_2Ew2n: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > tyop_2Enum_2Enum ) ).

thf(c_2Ewords_2Ew2s,type,
    c_2Ewords_2Ew2s: 
      !>[A_27a: $tType] : ( tyop_2Enum_2Enum > ( tyop_2Enum_2Enum > tyop_2Estring_2Echar ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Elist_2Elist @ tyop_2Estring_2Echar ) ) ).

thf(c_2Ewords_2Ew2w,type,
    c_2Ewords_2Ew2w: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27b ) ) ).

thf(c_2Ewords_2Eword__1comp,type,
    c_2Ewords_2Eword__1comp: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__2comp,type,
    c_2Ewords_2Eword__2comp: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__H,type,
    c_2Ewords_2Eword__H: 
      !>[A_27a: $tType] : ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ).

thf(c_2Ewords_2Eword__L,type,
    c_2Ewords_2Eword__L: 
      !>[A_27a: $tType] : ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ).

thf(c_2Ewords_2Eword__L2,type,
    c_2Ewords_2Eword__L2: 
      !>[A_27a: $tType] : ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ).

thf(c_2Ewords_2Eword__T,type,
    c_2Ewords_2Eword__T: 
      !>[A_27a: $tType] : ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ).

thf(c_2Ewords_2Eword__abs,type,
    c_2Ewords_2Eword__abs: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__add,type,
    c_2Ewords_2Eword__add: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__and,type,
    c_2Ewords_2Eword__and: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__asr,type,
    c_2Ewords_2Eword__asr: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__asr__bv,type,
    c_2Ewords_2Eword__asr__bv: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__bit,type,
    c_2Ewords_2Eword__bit: 
      !>[A_27a: $tType] : ( tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > $o ) ).

thf(c_2Ewords_2Eword__bits,type,
    c_2Ewords_2Eword__bits: 
      !>[A_27a: $tType] : ( tyop_2Enum_2Enum > tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__compare,type,
    c_2Ewords_2Eword__compare: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) ) ).

thf(c_2Ewords_2Eword__concat,type,
    c_2Ewords_2Eword__concat: 
      !>[A_27a: $tType,A_27b: $tType,A_27c: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27b ) > ( tyop_2Efcp_2Ecart @ $o @ A_27c ) ) ).

thf(c_2Ewords_2Eword__div,type,
    c_2Ewords_2Eword__div: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__extract,type,
    c_2Ewords_2Eword__extract: 
      !>[A_27a: $tType,A_27b: $tType] : ( tyop_2Enum_2Enum > tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27b ) ) ).

thf(c_2Ewords_2Eword__from__bin__list,type,
    c_2Ewords_2Eword__from__bin__list: 
      !>[A_27a: $tType] : ( ( tyop_2Elist_2Elist @ tyop_2Enum_2Enum ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__from__bin__string,type,
    c_2Ewords_2Eword__from__bin__string: 
      !>[A_27a: $tType] : ( ( tyop_2Elist_2Elist @ tyop_2Estring_2Echar ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__from__dec__list,type,
    c_2Ewords_2Eword__from__dec__list: 
      !>[A_27a: $tType] : ( ( tyop_2Elist_2Elist @ tyop_2Enum_2Enum ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__from__dec__string,type,
    c_2Ewords_2Eword__from__dec__string: 
      !>[A_27a: $tType] : ( ( tyop_2Elist_2Elist @ tyop_2Estring_2Echar ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__from__hex__list,type,
    c_2Ewords_2Eword__from__hex__list: 
      !>[A_27a: $tType] : ( ( tyop_2Elist_2Elist @ tyop_2Enum_2Enum ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__from__hex__string,type,
    c_2Ewords_2Eword__from__hex__string: 
      !>[A_27a: $tType] : ( ( tyop_2Elist_2Elist @ tyop_2Estring_2Echar ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__from__oct__list,type,
    c_2Ewords_2Eword__from__oct__list: 
      !>[A_27a: $tType] : ( ( tyop_2Elist_2Elist @ tyop_2Enum_2Enum ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__from__oct__string,type,
    c_2Ewords_2Eword__from__oct__string: 
      !>[A_27a: $tType] : ( ( tyop_2Elist_2Elist @ tyop_2Estring_2Echar ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__ge,type,
    c_2Ewords_2Eword__ge: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > $o ) ).

thf(c_2Ewords_2Eword__gt,type,
    c_2Ewords_2Eword__gt: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > $o ) ).

thf(c_2Ewords_2Eword__hi,type,
    c_2Ewords_2Eword__hi: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > $o ) ).

thf(c_2Ewords_2Eword__hs,type,
    c_2Ewords_2Eword__hs: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > $o ) ).

thf(c_2Ewords_2Eword__join,type,
    c_2Ewords_2Eword__join: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27b ) > ( tyop_2Efcp_2Ecart @ $o @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) ) ) ).

thf(c_2Ewords_2Eword__le,type,
    c_2Ewords_2Eword__le: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > $o ) ).

thf(c_2Ewords_2Eword__len,type,
    c_2Ewords_2Eword__len: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > tyop_2Enum_2Enum ) ).

thf(c_2Ewords_2Eword__lo,type,
    c_2Ewords_2Eword__lo: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > $o ) ).

thf(c_2Ewords_2Eword__log2,type,
    c_2Ewords_2Eword__log2: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__ls,type,
    c_2Ewords_2Eword__ls: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > $o ) ).

thf(c_2Ewords_2Eword__lsb,type,
    c_2Ewords_2Eword__lsb: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > $o ) ).

thf(c_2Ewords_2Eword__lsl,type,
    c_2Ewords_2Eword__lsl: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__lsl__bv,type,
    c_2Ewords_2Eword__lsl__bv: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__lsr,type,
    c_2Ewords_2Eword__lsr: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__lsr__bv,type,
    c_2Ewords_2Eword__lsr__bv: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__lt,type,
    c_2Ewords_2Eword__lt: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > $o ) ).

thf(c_2Ewords_2Eword__max,type,
    c_2Ewords_2Eword__max: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__min,type,
    c_2Ewords_2Eword__min: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__mod,type,
    c_2Ewords_2Eword__mod: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__modify,type,
    c_2Ewords_2Eword__modify: 
      !>[A_27a: $tType] : ( ( tyop_2Enum_2Enum > $o > $o ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__msb,type,
    c_2Ewords_2Eword__msb: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > $o ) ).

thf(c_2Ewords_2Eword__mul,type,
    c_2Ewords_2Eword__mul: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__nand,type,
    c_2Ewords_2Eword__nand: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__nor,type,
    c_2Ewords_2Eword__nor: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__or,type,
    c_2Ewords_2Eword__or: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__quot,type,
    c_2Ewords_2Eword__quot: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__reduce,type,
    c_2Ewords_2Eword__reduce: 
      !>[A_27a: $tType] : ( ( $o > $o > $o ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) ) ).

thf(c_2Ewords_2Eword__rem,type,
    c_2Ewords_2Eword__rem: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__replicate,type,
    c_2Ewords_2Eword__replicate: 
      !>[A_27a: $tType,A_27b: $tType] : ( tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27b ) ) ).

thf(c_2Ewords_2Eword__reverse,type,
    c_2Ewords_2Eword__reverse: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__rol,type,
    c_2Ewords_2Eword__rol: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__rol__bv,type,
    c_2Ewords_2Eword__rol__bv: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__ror,type,
    c_2Ewords_2Eword__ror: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__ror__bv,type,
    c_2Ewords_2Eword__ror__bv: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__rrx,type,
    c_2Ewords_2Eword__rrx: 
      !>[A_27a: $tType] : ( ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) > ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ) ).

thf(c_2Ewords_2Eword__sign__extend,type,
    c_2Ewords_2Eword__sign__extend: 
      !>[A_27a: $tType] : ( tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__signed__bits,type,
    c_2Ewords_2Eword__signed__bits: 
      !>[A_27a: $tType] : ( tyop_2Enum_2Enum > tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__slice,type,
    c_2Ewords_2Eword__slice: 
      !>[A_27a: $tType] : ( tyop_2Enum_2Enum > tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__smax,type,
    c_2Ewords_2Eword__smax: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__smin,type,
    c_2Ewords_2Eword__smin: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__sub,type,
    c_2Ewords_2Eword__sub: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__to__bin__list,type,
    c_2Ewords_2Eword__to__bin__list: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Elist_2Elist @ tyop_2Enum_2Enum ) ) ).

thf(c_2Ewords_2Eword__to__bin__string,type,
    c_2Ewords_2Eword__to__bin__string: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Elist_2Elist @ tyop_2Estring_2Echar ) ) ).

thf(c_2Ewords_2Eword__to__dec__list,type,
    c_2Ewords_2Eword__to__dec__list: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Elist_2Elist @ tyop_2Enum_2Enum ) ) ).

thf(c_2Ewords_2Eword__to__dec__string,type,
    c_2Ewords_2Eword__to__dec__string: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Elist_2Elist @ tyop_2Estring_2Echar ) ) ).

thf(c_2Ewords_2Eword__to__hex__list,type,
    c_2Ewords_2Eword__to__hex__list: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Elist_2Elist @ tyop_2Enum_2Enum ) ) ).

thf(c_2Ewords_2Eword__to__hex__string,type,
    c_2Ewords_2Eword__to__hex__string: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Elist_2Elist @ tyop_2Estring_2Echar ) ) ).

thf(c_2Ewords_2Eword__to__oct__list,type,
    c_2Ewords_2Eword__to__oct__list: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Elist_2Elist @ tyop_2Enum_2Enum ) ) ).

thf(c_2Ewords_2Eword__to__oct__string,type,
    c_2Ewords_2Eword__to__oct__string: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Elist_2Elist @ tyop_2Estring_2Echar ) ) ).

thf(c_2Ewords_2Eword__xnor,type,
    c_2Ewords_2Eword__xnor: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__xor,type,
    c_2Ewords_2Eword__xor: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ebool_2E_7E,type,
    c_2Ebool_2E_7E: $o > $o ).

thf(logicdef_2E_2F_5C,axiom,
    ! [V0: $o,V1: $o] :
      ( ( c_2Ebool_2E_2F_5C @ V0 @ V1 )
    <=> ( V0
        & V1 ) ) ).

thf(logicdef_2E_5C_2F,axiom,
    ! [V0: $o,V1: $o] :
      ( ( c_2Ebool_2E_5C_2F @ V0 @ V1 )
    <=> ( V0
        | V1 ) ) ).

thf(logicdef_2E_7E,axiom,
    ! [V0: $o] :
      ( ( c_2Ebool_2E_7E @ V0 )
    <=> ( (~) @ V0 ) ) ).

thf(logicdef_2E_3D_3D_3E,axiom,
    ! [V0: $o,V1: $o] :
      ( ( c_2Emin_2E_3D_3D_3E @ V0 @ V1 )
    <=> ( V0
       => V1 ) ) ).

thf(logicdef_2E_3D,axiom,
    ! [A_27a: $tType,V0: A_27a,V1: A_27a] :
      ( ( c_2Emin_2E_3D @ A_27a @ V0 @ V1 )
    <=> ( V0 = V1 ) ) ).

thf(quantdef_2E_21,axiom,
    ! [A_27a: $tType,V0f: A_27a > $o] :
      ( ( c_2Ebool_2E_21 @ A_27a @ V0f )
    <=> ! [V1x: A_27a] : ( V0f @ V1x ) ) ).

thf(quantdef_2E_3F,axiom,
    ! [A_27a: $tType,V0f: A_27a > $o] :
      ( ( c_2Ebool_2E_3F @ A_27a @ V0f )
    <=> ? [V1x: A_27a] : ( V0f @ V1x ) ) ).

thf(thm_2Ewords_2Edimword__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
      = ( c_2Earithmetic_2EEXP @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ).

thf(thm_2Ewords_2EINT__MIN__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2EINT__MIN @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
      = ( c_2Earithmetic_2EEXP @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Ewords_2EUINT__MAX__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2EUINT__MAX @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
      = ( c_2Earithmetic_2E_2D @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Ewords_2EINT__MAX__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2EINT__MAX @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
      = ( c_2Earithmetic_2E_2D @ ( c_2Ewords_2EINT__MIN @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Ewords_2Ew2n__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ew2n @ A_27a @ V0w )
      = ( c_2Esum__num_2ESUM @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
        @ ^ [V1i: tyop_2Enum_2Enum] : ( c_2Ebit_2ESBIT @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0w @ V1i ) @ V1i ) ) ) ).

thf(thm_2Ewords_2En2w__def,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2En2w @ A_27a @ V0n )
      = ( c_2Efcp_2EFCP @ $o @ A_27a
        @ ^ [V1i: tyop_2Enum_2Enum] : ( c_2Ebit_2EBIT @ V1i @ V0n ) ) ) ).

thf(thm_2Ewords_2Ew2w__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V0w )
      = ( c_2Ewords_2En2w @ A_27b @ ( c_2Ewords_2Ew2n @ A_27a @ V0w ) ) ) ).

thf(thm_2Ewords_2Esw2sw__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Esw2sw @ A_27a @ A_27b @ V0w )
      = ( c_2Ewords_2En2w @ A_27b @ ( c_2Ebit_2ESIGN__EXTEND @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ ( c_2Ewords_2Ew2n @ A_27a @ V0w ) ) ) ) ).

thf(thm_2Ewords_2Ew2l__def,axiom,
    ! [A_27a: $tType,V0b: tyop_2Enum_2Enum,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ew2l @ A_27a @ V0b @ V1w )
      = ( c_2Enumposrep_2En2l @ V0b @ ( c_2Ewords_2Ew2n @ A_27a @ V1w ) ) ) ).

thf(thm_2Ewords_2El2w__def,axiom,
    ! [A_27a: $tType,V0b: tyop_2Enum_2Enum,V1l: tyop_2Elist_2Elist @ tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2El2w @ A_27a @ V0b @ V1l )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Enumposrep_2El2n @ V0b @ V1l ) ) ) ).

thf(thm_2Ewords_2Ew2s__def,axiom,
    ! [A_27a: $tType,V0b: tyop_2Enum_2Enum,V1f: tyop_2Enum_2Enum > tyop_2Estring_2Echar,V2w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ew2s @ A_27a @ V0b @ V1f @ V2w )
      = ( c_2EASCIInumbers_2En2s @ V0b @ V1f @ ( c_2Ewords_2Ew2n @ A_27a @ V2w ) ) ) ).

thf(thm_2Ewords_2Es2w__def,axiom,
    ! [A_27a: $tType,V0b: tyop_2Enum_2Enum,V1f: tyop_2Estring_2Echar > tyop_2Enum_2Enum,V2s: tyop_2Elist_2Elist @ tyop_2Estring_2Echar] :
      ( ( c_2Ewords_2Es2w @ A_27a @ V0b @ V1f @ V2s )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2EASCIInumbers_2Es2n @ V0b @ V1f @ V2s ) ) ) ).

thf(thm_2Ewords_2Eword__from__bin__list__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__from__bin__list @ A_27a )
      = ( c_2Ewords_2El2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Ewords_2Eword__from__oct__list__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__from__oct__list @ A_27a )
      = ( c_2Ewords_2El2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__from__dec__list__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__from__dec__list @ A_27a )
      = ( c_2Ewords_2El2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__from__hex__list__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__from__hex__list @ A_27a )
      = ( c_2Ewords_2El2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__to__bin__list__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__to__bin__list @ A_27a )
      = ( c_2Ewords_2Ew2l @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Ewords_2Eword__to__oct__list__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__to__oct__list @ A_27a )
      = ( c_2Ewords_2Ew2l @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__to__dec__list__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__to__dec__list @ A_27a )
      = ( c_2Ewords_2Ew2l @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__to__hex__list__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__to__hex__list @ A_27a )
      = ( c_2Ewords_2Ew2l @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__from__bin__string__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__from__bin__string @ A_27a )
      = ( c_2Ewords_2Es2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) @ c_2EASCIInumbers_2EUNHEX ) ) ).

thf(thm_2Ewords_2Eword__from__oct__string__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__from__oct__string @ A_27a )
      = ( c_2Ewords_2Es2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ c_2EASCIInumbers_2EUNHEX ) ) ).

thf(thm_2Ewords_2Eword__from__dec__string__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__from__dec__string @ A_27a )
      = ( c_2Ewords_2Es2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ c_2EASCIInumbers_2EUNHEX ) ) ).

thf(thm_2Ewords_2Eword__from__hex__string__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__from__hex__string @ A_27a )
      = ( c_2Ewords_2Es2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ c_2EASCIInumbers_2EUNHEX ) ) ).

thf(thm_2Ewords_2Eword__to__bin__string__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__to__bin__string @ A_27a )
      = ( c_2Ewords_2Ew2s @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) @ c_2EASCIInumbers_2EHEX ) ) ).

thf(thm_2Ewords_2Eword__to__oct__string__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__to__oct__string @ A_27a )
      = ( c_2Ewords_2Ew2s @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ c_2EASCIInumbers_2EHEX ) ) ).

thf(thm_2Ewords_2Eword__to__dec__string__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__to__dec__string @ A_27a )
      = ( c_2Ewords_2Ew2s @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ c_2EASCIInumbers_2EHEX ) ) ).

thf(thm_2Ewords_2Eword__to__hex__string__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__to__hex__string @ A_27a )
      = ( c_2Ewords_2Ew2s @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ c_2EASCIInumbers_2EHEX ) ) ).

thf(thm_2Ewords_2Eword__T__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__T @ A_27a )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Ewords_2EUINT__MAX @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ).

thf(thm_2Ewords_2Eword__L__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__L @ A_27a )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Ewords_2EINT__MIN @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ).

thf(thm_2Ewords_2Eword__H__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__H @ A_27a )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Ewords_2EINT__MAX @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ).

thf(thm_2Ewords_2Eword__1comp__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__1comp @ A_27a @ V0w )
      = ( c_2Efcp_2EFCP @ $o @ A_27a
        @ ^ [V1i: tyop_2Enum_2Enum] : ( c_2Ebool_2E_7E @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0w @ V1i ) ) ) ) ).

thf(thm_2Ewords_2Eword__and__def,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__and @ A_27a @ V0v @ V1w )
      = ( c_2Efcp_2EFCP @ $o @ A_27a
        @ ^ [V2i: tyop_2Enum_2Enum] : ( c_2Ebool_2E_2F_5C @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0v @ V2i ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V1w @ V2i ) ) ) ) ).

thf(thm_2Ewords_2Eword__or__def,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__or @ A_27a @ V0v @ V1w )
      = ( c_2Efcp_2EFCP @ $o @ A_27a
        @ ^ [V2i: tyop_2Enum_2Enum] : ( c_2Ebool_2E_5C_2F @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0v @ V2i ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V1w @ V2i ) ) ) ) ).

thf(thm_2Ewords_2Eword__xor__def,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__xor @ A_27a @ V0v @ V1w )
      = ( c_2Efcp_2EFCP @ $o @ A_27a
        @ ^ [V2i: tyop_2Enum_2Enum] : ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ $o @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0v @ V2i ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V1w @ V2i ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__nand__def,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__nand @ A_27a @ V0v @ V1w )
      = ( c_2Efcp_2EFCP @ $o @ A_27a
        @ ^ [V2i: tyop_2Enum_2Enum] : ( c_2Ebool_2E_7E @ ( c_2Ebool_2E_2F_5C @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0v @ V2i ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V1w @ V2i ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__nor__def,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__nor @ A_27a @ V0v @ V1w )
      = ( c_2Efcp_2EFCP @ $o @ A_27a
        @ ^ [V2i: tyop_2Enum_2Enum] : ( c_2Ebool_2E_7E @ ( c_2Ebool_2E_5C_2F @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0v @ V2i ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V1w @ V2i ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__xnor__def,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__xnor @ A_27a @ V0v @ V1w )
      = ( c_2Efcp_2EFCP @ $o @ A_27a
        @ ^ [V2i: tyop_2Enum_2Enum] : ( c_2Emin_2E_3D @ $o @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0v @ V2i ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V1w @ V2i ) ) ) ) ).

thf(thm_2Ewords_2Eword__reduce__def,axiom,
    ! [A_27a: $tType,V0f: $o > $o > $o,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__reduce @ A_27a @ V0f @ V1w )
      = ( c_2Efcp_2EFCP @ $o @ tyop_2Eone_2Eone
        @ ( c_2Ecombin_2EK @ $o @ tyop_2Enum_2Enum
          @ ( c_2Ebool_2ELET @ ( tyop_2Elist_2Elist @ $o ) @ $o
            @ ^ [V2l: tyop_2Elist_2Elist @ $o] : ( c_2Elist_2EFOLDL @ $o @ $o @ V0f @ ( c_2Elist_2EHD @ $o @ V2l ) @ ( c_2Elist_2ETL @ $o @ V2l ) )
            @ ( c_2Elist_2EGENLIST @ $o
              @ ^ [V3i: tyop_2Enum_2Enum] : ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V1w @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V3i ) )
              @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__compare__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__compare @ A_27a @ V0a @ V1b )
      = ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ V0a @ V1b ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ewords_2Ereduce__and__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Ereduce__and @ A_27a )
      = ( c_2Ewords_2Eword__reduce @ A_27a @ c_2Ebool_2E_2F_5C ) ) ).

thf(thm_2Ewords_2Ereduce__or__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Ereduce__or @ A_27a )
      = ( c_2Ewords_2Eword__reduce @ A_27a @ c_2Ebool_2E_5C_2F ) ) ).

thf(thm_2Ewords_2Ereduce__xor__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Ereduce__xor @ A_27a )
      = ( c_2Ewords_2Eword__reduce @ A_27a
        @ ^ [V0x: $o,V1y: $o] : ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ $o @ V0x @ V1y ) ) ) ) ).

thf(thm_2Ewords_2Ereduce__nand__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Ereduce__nand @ A_27a )
      = ( c_2Ewords_2Eword__reduce @ A_27a
        @ ^ [V0a: $o,V1b: $o] : ( c_2Ebool_2E_7E @ ( c_2Ebool_2E_2F_5C @ V0a @ V1b ) ) ) ) ).

thf(thm_2Ewords_2Ereduce__nor__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Ereduce__nor @ A_27a )
      = ( c_2Ewords_2Eword__reduce @ A_27a
        @ ^ [V0a: $o,V1b: $o] : ( c_2Ebool_2E_7E @ ( c_2Ebool_2E_5C_2F @ V0a @ V1b ) ) ) ) ).

thf(thm_2Ewords_2Ereduce__xnor__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Ereduce__xnor @ A_27a )
      = ( c_2Ewords_2Eword__reduce @ A_27a @ ( c_2Emin_2E_3D @ $o ) ) ) ).

thf(thm_2Ewords_2Eword__lsb__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__lsb @ A_27a @ V0w )
      = ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0w @ c_2Enum_2E0 ) ) ).

thf(thm_2Ewords_2Eword__msb__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__msb @ A_27a @ V0w )
      = ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0w @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__slice__def,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__slice @ A_27a @ V0h @ V1l )
      = ( ^ [V2w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
            ( c_2Efcp_2EFCP @ $o @ A_27a
            @ ^ [V3i: tyop_2Enum_2Enum] : ( c_2Ebool_2E_2F_5C @ ( c_2Earithmetic_2E_3C_3D @ V1l @ V3i ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Earithmetic_2E_3C_3D @ V3i @ ( c_2Earithmetic_2EMIN @ V0h @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V2w @ V3i ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__bits__def,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ V1l )
      = ( ^ [V2w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
            ( c_2Efcp_2EFCP @ $o @ A_27a
            @ ^ [V3i: tyop_2Enum_2Enum] : ( c_2Ebool_2E_2F_5C @ ( c_2Earithmetic_2E_3C_3D @ ( c_2Earithmetic_2E_2B @ V3i @ V1l ) @ ( c_2Earithmetic_2EMIN @ V0h @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V2w @ ( c_2Earithmetic_2E_2B @ V3i @ V1l ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__signed__bits__def,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__signed__bits @ A_27a @ V0h @ V1l )
      = ( ^ [V2w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
            ( c_2Efcp_2EFCP @ $o @ A_27a
            @ ^ [V3i: tyop_2Enum_2Enum] : ( c_2Ebool_2E_2F_5C @ ( c_2Earithmetic_2E_3C_3D @ V1l @ ( c_2Earithmetic_2EMIN @ V0h @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V2w @ ( c_2Earithmetic_2EMIN @ ( c_2Earithmetic_2E_2B @ V3i @ V1l ) @ ( c_2Earithmetic_2EMIN @ V0h @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__extract__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V0h @ V1l )
      = ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27b ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b ) @ ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ V1l ) ) ) ).

thf(thm_2Ewords_2Eword__bit__def,axiom,
    ! [A_27a: $tType,V0b: tyop_2Enum_2Enum,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__bit @ A_27a @ V0b @ V1w )
    <=> ( ( c_2Earithmetic_2E_3C_3D @ V0b @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
        & ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V1w @ V0b ) ) ) ).

thf(thm_2Ewords_2Eword__reverse__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__reverse @ A_27a @ V0w )
      = ( c_2Efcp_2EFCP @ $o @ A_27a
        @ ^ [V1i: tyop_2Enum_2Enum] : ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0w @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V1i ) ) ) ) ).

thf(thm_2Ewords_2Eword__modify__def,axiom,
    ! [A_27a: $tType,V0f: tyop_2Enum_2Enum > $o > $o,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__modify @ A_27a @ V0f @ V1w )
      = ( c_2Efcp_2EFCP @ $o @ A_27a
        @ ^ [V2i: tyop_2Enum_2Enum] : ( V0f @ V2i @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V1w @ V2i ) ) ) ) ).

thf(thm_2Ewords_2Ebit__field__insert__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2a: tyop_2Efcp_2Ecart @ $o @ A_27b] :
      ( ( c_2Ewords_2Ebit__field__insert @ A_27a @ A_27b @ V0h @ V1l @ V2a )
      = ( c_2Ewords_2Eword__modify @ A_27a
        @ ^ [V3i: tyop_2Enum_2Enum] : ( c_2Ebool_2ECOND @ $o @ ( c_2Ebool_2E_2F_5C @ ( c_2Earithmetic_2E_3C_3D @ V1l @ V3i ) @ ( c_2Earithmetic_2E_3C_3D @ V3i @ V0h ) ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27b @ V2a @ ( c_2Earithmetic_2E_2D @ V3i @ V1l ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__sign__extend__def,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__sign__extend @ A_27a @ V0n @ V1w )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Ebit_2ESIGN__EXTEND @ V0n @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2Ew2n @ A_27a @ V1w ) ) ) ) ).

thf(thm_2Ewords_2Eword__len__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__len @ A_27a @ V0w )
      = ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ).

thf(thm_2Ewords_2Ebit__count__upto__def,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ebit__count__upto @ A_27a @ V0n @ V1w )
      = ( c_2Esum__num_2ESUM @ V0n
        @ ^ [V2i: tyop_2Enum_2Enum] : ( c_2Ebool_2ECOND @ tyop_2Enum_2Enum @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V1w @ V2i ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ewords_2Ebit__count__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ebit__count @ A_27a @ V0w )
      = ( c_2Ewords_2Ebit__count__upto @ A_27a @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ V0w ) ) ).

thf(thm_2Ewords_2Eword__2comp__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__2comp @ A_27a @ V0w )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2E_2D @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2Ew2n @ A_27a @ V0w ) ) ) ) ).

thf(thm_2Ewords_2Eword__add__def,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V1w )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2E_2B @ ( c_2Ewords_2Ew2n @ A_27a @ V0v ) @ ( c_2Ewords_2Ew2n @ A_27a @ V1w ) ) ) ) ).

thf(thm_2Ewords_2Eword__mul__def,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ V1w )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2E_2A @ ( c_2Ewords_2Ew2n @ A_27a @ V0v ) @ ( c_2Ewords_2Ew2n @ A_27a @ V1w ) ) ) ) ).

thf(thm_2Ewords_2Eword__log2__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__log2 @ A_27a @ V0w )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Ebit_2ELOG2 @ ( c_2Ewords_2Ew2n @ A_27a @ V0w ) ) ) ) ).

thf(thm_2Ewords_2Eadd__with__carry__def,axiom,
    ! [A_27a: $tType,V0x: tyop_2Efcp_2Ecart @ $o @ A_27a,V1y: tyop_2Efcp_2Ecart @ $o @ A_27a,V2carry__in: $o] :
      ( ( c_2Ewords_2Eadd__with__carry @ A_27a @ ( c_2Epair_2E_2C @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ $o ) @ V0x @ ( c_2Epair_2E_2C @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ $o @ V1y @ V2carry__in ) ) )
      = ( c_2Ebool_2ELET @ tyop_2Enum_2Enum @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Epair_2Eprod @ $o @ $o ) )
        @ ^ [V3unsigned__sum: tyop_2Enum_2Enum] :
            ( c_2Ebool_2ELET @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Epair_2Eprod @ $o @ $o ) )
            @ ^ [V4result: tyop_2Efcp_2Ecart @ $o @ A_27a] :
                ( c_2Ebool_2ELET @ $o @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Epair_2Eprod @ $o @ $o ) )
                @ ( c_2Ebool_2ELET @ $o @ ( $o > ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) )
                  @ ^ [V5carry__out: $o,V6overflow: $o] : ( c_2Epair_2E_2C @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Epair_2Eprod @ $o @ $o ) @ V4result @ ( c_2Epair_2E_2C @ $o @ $o @ V5carry__out @ V6overflow ) )
                  @ ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ tyop_2Enum_2Enum @ ( c_2Ewords_2Ew2n @ A_27a @ V4result ) @ V3unsigned__sum ) ) )
                @ ( c_2Ebool_2E_2F_5C @ ( c_2Emin_2E_3D @ $o @ ( c_2Ewords_2Eword__msb @ A_27a @ V0x ) @ ( c_2Ewords_2Eword__msb @ A_27a @ V1y ) ) @ ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ $o @ ( c_2Ewords_2Eword__msb @ A_27a @ V0x ) @ ( c_2Ewords_2Eword__msb @ A_27a @ V4result ) ) ) ) )
            @ ( c_2Ewords_2En2w @ A_27a @ V3unsigned__sum ) )
        @ ( c_2Earithmetic_2E_2B @ ( c_2Earithmetic_2E_2B @ ( c_2Ewords_2Ew2n @ A_27a @ V0x ) @ ( c_2Ewords_2Ew2n @ A_27a @ V1y ) ) @ ( c_2Ebool_2ECOND @ tyop_2Enum_2Enum @ V2carry__in @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ c_2Enum_2E0 ) ) ) ) ).

thf(thm_2Ewords_2Eword__sub__def,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__sub @ A_27a @ V0v @ V1w )
      = ( c_2Ewords_2Eword__add @ A_27a @ V0v @ ( c_2Ewords_2Eword__2comp @ A_27a @ V1w ) ) ) ).

thf(thm_2Ewords_2Eword__div__def,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__div @ A_27a @ V0v @ V1w )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2EDIV @ ( c_2Ewords_2Ew2n @ A_27a @ V0v ) @ ( c_2Ewords_2Ew2n @ A_27a @ V1w ) ) ) ) ).

thf(thm_2Ewords_2Eword__mod__def,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__mod @ A_27a @ V0v @ V1w )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2EMOD @ ( c_2Ewords_2Ew2n @ A_27a @ V0v ) @ ( c_2Ewords_2Ew2n @ A_27a @ V1w ) ) ) ) ).

thf(thm_2Ewords_2Eword__quot__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__quot @ A_27a @ V0a @ V1b )
      = ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( c_2Ewords_2Eword__msb @ A_27a @ V0a ) @ ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( c_2Ewords_2Eword__msb @ A_27a @ V1b ) @ ( c_2Ewords_2Eword__div @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V0a ) @ ( c_2Ewords_2Eword__2comp @ A_27a @ V1b ) ) @ ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2Eword__div @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V0a ) @ V1b ) ) ) @ ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( c_2Ewords_2Eword__msb @ A_27a @ V1b ) @ ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2Eword__div @ A_27a @ V0a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V1b ) ) ) @ ( c_2Ewords_2Eword__div @ A_27a @ V0a @ V1b ) ) ) ) ).

thf(thm_2Ewords_2Eword__rem__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__rem @ A_27a @ V0a @ V1b )
      = ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( c_2Ewords_2Eword__msb @ A_27a @ V0a ) @ ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( c_2Ewords_2Eword__msb @ A_27a @ V1b ) @ ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2Eword__mod @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V0a ) @ ( c_2Ewords_2Eword__2comp @ A_27a @ V1b ) ) ) @ ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2Eword__mod @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V0a ) @ V1b ) ) ) @ ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( c_2Ewords_2Eword__msb @ A_27a @ V1b ) @ ( c_2Ewords_2Eword__mod @ A_27a @ V0a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V1b ) ) @ ( c_2Ewords_2Eword__mod @ A_27a @ V0a @ V1b ) ) ) ) ).

thf(thm_2Ewords_2Eword__L2__def,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__L2 @ A_27a )
      = ( c_2Ewords_2Eword__mul @ A_27a @ ( c_2Ewords_2Eword__L @ A_27a ) @ ( c_2Ewords_2Eword__L @ A_27a ) ) ) ).

thf(thm_2Ewords_2Enzcv__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Enzcv @ A_27a @ V0a @ V1b )
      = ( c_2Ebool_2ELET @ tyop_2Enum_2Enum @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) )
        @ ^ [V2q: tyop_2Enum_2Enum] :
            ( c_2Ebool_2ELET @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) )
            @ ^ [V3r: tyop_2Efcp_2Ecart @ $o @ A_27a] : ( c_2Epair_2E_2C @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) @ ( c_2Ewords_2Eword__msb @ A_27a @ V3r ) @ ( c_2Epair_2E_2C @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ V3r @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) @ ( c_2Epair_2E_2C @ $o @ $o @ ( c_2Ebool_2E_5C_2F @ ( c_2Ebit_2EBIT @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ V2q ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ V1b @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ $o @ ( c_2Ewords_2Eword__msb @ A_27a @ V0a ) @ ( c_2Ewords_2Eword__msb @ A_27a @ V1b ) ) ) @ ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ $o @ ( c_2Ewords_2Eword__msb @ A_27a @ V3r ) @ ( c_2Ewords_2Eword__msb @ A_27a @ V0a ) ) ) ) ) ) )
            @ ( c_2Ewords_2En2w @ A_27a @ V2q ) )
        @ ( c_2Earithmetic_2E_2B @ ( c_2Ewords_2Ew2n @ A_27a @ V0a ) @ ( c_2Ewords_2Ew2n @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V1b ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__lt__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__lt @ A_27a @ V0a @ V1b )
      = ( c_2Ebool_2ELET @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) @ $o
        @ ( c_2Epair_2EUNCURRY @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) @ $o
          @ ^ [V2n: $o] :
              ( c_2Epair_2EUNCURRY @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) @ $o
              @ ^ [V3z: $o] :
                  ( c_2Epair_2EUNCURRY @ $o @ $o @ $o
                  @ ^ [V4c: $o,V5v: $o] : ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ $o @ V2n @ V5v ) ) ) ) )
        @ ( c_2Ewords_2Enzcv @ A_27a @ V0a @ V1b ) ) ) ).

thf(thm_2Ewords_2Eword__gt__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__gt @ A_27a @ V0a @ V1b )
      = ( c_2Ebool_2ELET @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) @ $o
        @ ( c_2Epair_2EUNCURRY @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) @ $o
          @ ^ [V2n: $o] :
              ( c_2Epair_2EUNCURRY @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) @ $o
              @ ^ [V3z: $o] :
                  ( c_2Epair_2EUNCURRY @ $o @ $o @ $o
                  @ ^ [V4c: $o,V5v: $o] : ( c_2Ebool_2E_2F_5C @ ( c_2Ebool_2E_7E @ V3z ) @ ( c_2Emin_2E_3D @ $o @ V2n @ V5v ) ) ) ) )
        @ ( c_2Ewords_2Enzcv @ A_27a @ V0a @ V1b ) ) ) ).

thf(thm_2Ewords_2Eword__le__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__le @ A_27a @ V0a @ V1b )
      = ( c_2Ebool_2ELET @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) @ $o
        @ ( c_2Epair_2EUNCURRY @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) @ $o
          @ ^ [V2n: $o] :
              ( c_2Epair_2EUNCURRY @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) @ $o
              @ ^ [V3z: $o] :
                  ( c_2Epair_2EUNCURRY @ $o @ $o @ $o
                  @ ^ [V4c: $o,V5v: $o] : ( c_2Ebool_2E_5C_2F @ V3z @ ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ $o @ V2n @ V5v ) ) ) ) ) )
        @ ( c_2Ewords_2Enzcv @ A_27a @ V0a @ V1b ) ) ) ).

thf(thm_2Ewords_2Eword__ge__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__ge @ A_27a @ V0a @ V1b )
      = ( c_2Ebool_2ELET @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) @ $o
        @ ( c_2Epair_2EUNCURRY @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) @ $o
          @ ^ [V2n: $o] :
              ( c_2Epair_2EUNCURRY @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) @ $o
              @ ^ [V3z: $o] :
                  ( c_2Epair_2EUNCURRY @ $o @ $o @ $o
                  @ ^ [V4c: $o,V5v: $o] : ( c_2Emin_2E_3D @ $o @ V2n @ V5v ) ) ) )
        @ ( c_2Ewords_2Enzcv @ A_27a @ V0a @ V1b ) ) ) ).

thf(thm_2Ewords_2Eword__ls__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__ls @ A_27a @ V0a @ V1b )
      = ( c_2Ebool_2ELET @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) @ $o
        @ ( c_2Epair_2EUNCURRY @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) @ $o
          @ ^ [V2n: $o] :
              ( c_2Epair_2EUNCURRY @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) @ $o
              @ ^ [V3z: $o] :
                  ( c_2Epair_2EUNCURRY @ $o @ $o @ $o
                  @ ^ [V4c: $o,V5v: $o] : ( c_2Ebool_2E_5C_2F @ ( c_2Ebool_2E_7E @ V4c ) @ V3z ) ) ) )
        @ ( c_2Ewords_2Enzcv @ A_27a @ V0a @ V1b ) ) ) ).

thf(thm_2Ewords_2Eword__hi__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__hi @ A_27a @ V0a @ V1b )
      = ( c_2Ebool_2ELET @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) @ $o
        @ ( c_2Epair_2EUNCURRY @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) @ $o
          @ ^ [V2n: $o] :
              ( c_2Epair_2EUNCURRY @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) @ $o
              @ ^ [V3z: $o] :
                  ( c_2Epair_2EUNCURRY @ $o @ $o @ $o
                  @ ^ [V4c: $o,V5v: $o] : ( c_2Ebool_2E_2F_5C @ V4c @ ( c_2Ebool_2E_7E @ V3z ) ) ) ) )
        @ ( c_2Ewords_2Enzcv @ A_27a @ V0a @ V1b ) ) ) ).

thf(thm_2Ewords_2Eword__lo__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__lo @ A_27a @ V0a @ V1b )
      = ( c_2Ebool_2ELET @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) @ $o
        @ ( c_2Epair_2EUNCURRY @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) @ $o
          @ ^ [V2n: $o] :
              ( c_2Epair_2EUNCURRY @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) @ $o
              @ ^ [V3z: $o] :
                  ( c_2Epair_2EUNCURRY @ $o @ $o @ $o
                  @ ^ [V4c: $o,V5v: $o] : ( c_2Ebool_2E_7E @ V4c ) ) ) )
        @ ( c_2Ewords_2Enzcv @ A_27a @ V0a @ V1b ) ) ) ).

thf(thm_2Ewords_2Eword__hs__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__hs @ A_27a @ V0a @ V1b )
      = ( c_2Ebool_2ELET @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) @ $o
        @ ( c_2Epair_2EUNCURRY @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) @ $o
          @ ^ [V2n: $o] :
              ( c_2Epair_2EUNCURRY @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) @ $o
              @ ^ [V3z: $o] :
                  ( c_2Epair_2EUNCURRY @ $o @ $o @ $o
                  @ ^ [V4c: $o,V5v: $o] : V4c ) ) )
        @ ( c_2Ewords_2Enzcv @ A_27a @ V0a @ V1b ) ) ) ).

thf(thm_2Ewords_2Eword__min__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__min @ A_27a @ V0a @ V1b )
      = ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( c_2Ewords_2Eword__lo @ A_27a @ V0a @ V1b ) @ V0a @ V1b ) ) ).

thf(thm_2Ewords_2Eword__max__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__max @ A_27a @ V0a @ V1b )
      = ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( c_2Ewords_2Eword__lo @ A_27a @ V0a @ V1b ) @ V1b @ V0a ) ) ).

thf(thm_2Ewords_2Eword__smin__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__smin @ A_27a @ V0a @ V1b )
      = ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( c_2Ewords_2Eword__lt @ A_27a @ V0a @ V1b ) @ V0a @ V1b ) ) ).

thf(thm_2Ewords_2Eword__smax__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__smax @ A_27a @ V0a @ V1b )
      = ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( c_2Ewords_2Eword__lt @ A_27a @ V0a @ V1b ) @ V1b @ V0a ) ) ).

thf(thm_2Ewords_2Eword__abs__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__abs @ A_27a @ V0w )
      = ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( c_2Ewords_2Eword__lt @ A_27a @ V0w @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) @ ( c_2Ewords_2Eword__2comp @ A_27a @ V0w ) @ V0w ) ) ).

thf(thm_2Ewords_2Eword__lsl__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__lsl @ A_27a @ V0w @ V1n )
      = ( c_2Efcp_2EFCP @ $o @ A_27a
        @ ^ [V2i: tyop_2Enum_2Enum] : ( c_2Ebool_2E_2F_5C @ ( c_2Eprim__rec_2E_3C @ V2i @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Earithmetic_2E_3C_3D @ V1n @ V2i ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0w @ ( c_2Earithmetic_2E_2D @ V2i @ V1n ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__lsr__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__lsr @ A_27a @ V0w @ V1n )
      = ( c_2Efcp_2EFCP @ $o @ A_27a
        @ ^ [V2i: tyop_2Enum_2Enum] : ( c_2Ebool_2E_2F_5C @ ( c_2Eprim__rec_2E_3C @ ( c_2Earithmetic_2E_2B @ V2i @ V1n ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0w @ ( c_2Earithmetic_2E_2B @ V2i @ V1n ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__asr__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__asr @ A_27a @ V0w @ V1n )
      = ( c_2Efcp_2EFCP @ $o @ A_27a
        @ ^ [V2i: tyop_2Enum_2Enum] : ( c_2Ebool_2ECOND @ $o @ ( c_2Earithmetic_2E_3C_3D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2E_2B @ V2i @ V1n ) ) @ ( c_2Ewords_2Eword__msb @ A_27a @ V0w ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0w @ ( c_2Earithmetic_2E_2B @ V2i @ V1n ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__ror__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__ror @ A_27a @ V0w @ V1n )
      = ( c_2Efcp_2EFCP @ $o @ A_27a
        @ ^ [V2i: tyop_2Enum_2Enum] : ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0w @ ( c_2Earithmetic_2EMOD @ ( c_2Earithmetic_2E_2B @ V2i @ V1n ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__rol__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__rol @ A_27a @ V0w @ V1n )
      = ( c_2Ewords_2Eword__ror @ A_27a @ V0w @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2EMOD @ V1n @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__rrx__def,axiom,
    ! [A_27a: $tType,V0c: $o,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__rrx @ A_27a @ ( c_2Epair_2E_2C @ $o @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ V0c @ V1w ) )
      = ( c_2Epair_2E_2C @ $o @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( c_2Ewords_2Eword__lsb @ A_27a @ V1w )
        @ ( c_2Efcp_2EFCP @ $o @ A_27a
          @ ^ [V2i: tyop_2Enum_2Enum] : ( c_2Ebool_2ECOND @ $o @ ( c_2Emin_2E_3D @ tyop_2Enum_2Enum @ V2i @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ V0c @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ ( c_2Ewords_2Eword__lsr @ A_27a @ V1w @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V2i ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__lsl__bv__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1n: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__lsl__bv @ A_27a @ V0w @ V1n )
      = ( c_2Ewords_2Eword__lsl @ A_27a @ V0w @ ( c_2Ewords_2Ew2n @ A_27a @ V1n ) ) ) ).

thf(thm_2Ewords_2Eword__lsr__bv__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1n: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__lsr__bv @ A_27a @ V0w @ V1n )
      = ( c_2Ewords_2Eword__lsr @ A_27a @ V0w @ ( c_2Ewords_2Ew2n @ A_27a @ V1n ) ) ) ).

thf(thm_2Ewords_2Eword__asr__bv__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1n: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__asr__bv @ A_27a @ V0w @ V1n )
      = ( c_2Ewords_2Eword__asr @ A_27a @ V0w @ ( c_2Ewords_2Ew2n @ A_27a @ V1n ) ) ) ).

thf(thm_2Ewords_2Eword__ror__bv__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1n: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__ror__bv @ A_27a @ V0w @ V1n )
      = ( c_2Ewords_2Eword__ror @ A_27a @ V0w @ ( c_2Ewords_2Ew2n @ A_27a @ V1n ) ) ) ).

thf(thm_2Ewords_2Eword__rol__bv__def,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1n: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__rol__bv @ A_27a @ V0w @ V1n )
      = ( c_2Ewords_2Eword__rol @ A_27a @ V0w @ ( c_2Ewords_2Ew2n @ A_27a @ V1n ) ) ) ).

thf(thm_2Ewords_2Eword__join__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27b] :
      ( ( c_2Ewords_2Eword__join @ A_27a @ A_27b @ V0v @ V1w )
      = ( c_2Ebool_2ELET @ ( tyop_2Efcp_2Ecart @ $o @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) ) @ ( tyop_2Efcp_2Ecart @ $o @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) )
        @ ( c_2Ebool_2ELET @ ( tyop_2Efcp_2Ecart @ $o @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) ) @ ( ( tyop_2Efcp_2Ecart @ $o @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) ) > ( tyop_2Efcp_2Ecart @ $o @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) ) )
          @ ^ [V2cv: tyop_2Efcp_2Ecart @ $o @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ),V3cw: tyop_2Efcp_2Ecart @ $o @ ( tyop_2Esum_2Esum @ A_27a @ A_27b )] : ( c_2Ewords_2Eword__or @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) @ ( c_2Ewords_2Eword__lsl @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) @ V2cv @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) @ V3cw )
          @ ( c_2Ewords_2Ew2w @ A_27a @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) @ V0v ) )
        @ ( c_2Ewords_2Ew2w @ A_27b @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) @ V1w ) ) ) ).

thf(thm_2Ewords_2Eword__concat__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27b] :
      ( ( c_2Ewords_2Eword__concat @ A_27a @ A_27b @ A_27c @ V0v @ V1w )
      = ( c_2Ewords_2Ew2w @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) @ A_27c @ ( c_2Ewords_2Eword__join @ A_27a @ A_27b @ V0v @ V1w ) ) ) ).

thf(thm_2Ewords_2Eword__replicate__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0n: tyop_2Enum_2Enum,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__replicate @ A_27a @ A_27b @ V0n @ V1w )
      = ( c_2Efcp_2EFCP @ $o @ A_27b
        @ ^ [V2i: tyop_2Enum_2Enum] : ( c_2Ebool_2E_2F_5C @ ( c_2Eprim__rec_2E_3C @ V2i @ ( c_2Earithmetic_2E_2A @ V0n @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V1w @ ( c_2Earithmetic_2EMOD @ V2i @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ) ) ).

thf(thm_2Ewords_2Econcat__word__list__def,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ( ( c_2Ewords_2Econcat__word__list @ A_27a @ A_27b @ ( c_2Elist_2ENIL @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) )
        = ( c_2Ewords_2En2w @ A_27b @ c_2Enum_2E0 ) )
      & ! [V0h: tyop_2Efcp_2Ecart @ $o @ A_27a,V1t: tyop_2Elist_2Elist @ ( tyop_2Efcp_2Ecart @ $o @ A_27a )] :
          ( ( c_2Ewords_2Econcat__word__list @ A_27a @ A_27b @ ( c_2Elist_2ECONS @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ V0h @ V1t ) )
          = ( c_2Ewords_2Eword__or @ A_27b @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V0h ) @ ( c_2Ewords_2Eword__lsl @ A_27b @ ( c_2Ewords_2Econcat__word__list @ A_27a @ A_27b @ V1t ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ) ).

thf(thm_2Ewords_2Esaturate__n2w__def,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Esaturate__n2w @ A_27a @ V0n )
      = ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( c_2Earithmetic_2E_3C_3D @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ V0n ) @ ( c_2Ewords_2Eword__T @ A_27a ) @ ( c_2Ewords_2En2w @ A_27a @ V0n ) ) ) ).

thf(thm_2Ewords_2Esaturate__w2w__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Esaturate__w2w @ A_27a @ A_27b @ V0w )
      = ( c_2Ewords_2Esaturate__n2w @ A_27b @ ( c_2Ewords_2Ew2n @ A_27a @ V0w ) ) ) ).

thf(thm_2Ewords_2Esaturate__add__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Esaturate__add @ A_27a @ V0a @ V1b )
      = ( c_2Ewords_2Esaturate__n2w @ A_27a @ ( c_2Earithmetic_2E_2B @ ( c_2Ewords_2Ew2n @ A_27a @ V0a ) @ ( c_2Ewords_2Ew2n @ A_27a @ V1b ) ) ) ) ).

thf(thm_2Ewords_2Esaturate__sub__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Esaturate__sub @ A_27a @ V0a @ V1b )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2E_2D @ ( c_2Ewords_2Ew2n @ A_27a @ V0a ) @ ( c_2Ewords_2Ew2n @ A_27a @ V1b ) ) ) ) ).

thf(thm_2Ewords_2Esaturate__mul__def,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Esaturate__mul @ A_27a @ V0a @ V1b )
      = ( c_2Ewords_2Esaturate__n2w @ A_27a @ ( c_2Earithmetic_2E_2A @ ( c_2Ewords_2Ew2n @ A_27a @ V0a ) @ ( c_2Ewords_2Ew2n @ A_27a @ V1b ) ) ) ) ).

thf(thm_2Ewords_2EBIT__SET__ind,axiom,
    ! [V0P: tyop_2Enum_2Enum > tyop_2Enum_2Enum > $o] :
      ( ! [V1i: tyop_2Enum_2Enum,V2n: tyop_2Enum_2Enum] :
          ( ( ( ( ( (~) @ ( V2n = c_2Enum_2E0 ) )
                & ( c_2Earithmetic_2EODD @ V2n ) )
             => ( V0P @ ( c_2Enum_2ESUC @ V1i ) @ ( c_2Earithmetic_2EDIV @ V2n @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) )
            & ( ( ( (~) @ ( V2n = c_2Enum_2E0 ) )
                & ( (~) @ ( c_2Earithmetic_2EODD @ V2n ) ) )
             => ( V0P @ ( c_2Enum_2ESUC @ V1i ) @ ( c_2Earithmetic_2EDIV @ V2n @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) ) )
         => ( V0P @ V1i @ V2n ) )
     => ! [V3v: tyop_2Enum_2Enum,V4v1: tyop_2Enum_2Enum] : ( V0P @ V3v @ V4v1 ) ) ).

thf(thm_2Ewords_2EBIT__SET__def,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1i: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2EBIT__SET @ V1i @ V0n )
      = ( c_2Ebool_2ECOND @ ( tyop_2Enum_2Enum > $o ) @ ( c_2Emin_2E_3D @ tyop_2Enum_2Enum @ V0n @ c_2Enum_2E0 ) @ ( c_2Epred__set_2EEMPTY @ tyop_2Enum_2Enum ) @ ( c_2Ebool_2ECOND @ ( tyop_2Enum_2Enum > $o ) @ ( c_2Earithmetic_2EODD @ V0n ) @ ( c_2Epred__set_2EINSERT @ tyop_2Enum_2Enum @ V1i @ ( c_2Ewords_2EBIT__SET @ ( c_2Enum_2ESUC @ V1i ) @ ( c_2Earithmetic_2EDIV @ V0n @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ ( c_2Ewords_2EBIT__SET @ ( c_2Enum_2ESUC @ V1i ) @ ( c_2Earithmetic_2EDIV @ V0n @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ).

thf(thm_2Ewords_2EZERO__LT__dimword,axiom,
    ! [A_27a: $tType] : ( c_2Eprim__rec_2E_3C @ c_2Enum_2E0 @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ).

thf(thm_2Ewords_2EDIMINDEX__GT__0,axiom,
    ! [A_27a: $tType] : ( c_2Eprim__rec_2E_3C @ c_2Enum_2E0 @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ).

thf(thm_2Ewords_2Edimword__IS__TWICE__INT__MIN,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
      = ( c_2Earithmetic_2E_2A @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Ewords_2EINT__MIN @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ).

thf(thm_2Ewords_2Edimword__sub__int__min,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Earithmetic_2E_2D @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2EINT__MIN @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
      = ( c_2Ewords_2EINT__MIN @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ).

thf(thm_2Ewords_2EONE__LT__dimword,axiom,
    ! [A_27a: $tType] : ( c_2Eprim__rec_2E_3C @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ).

thf(thm_2Ewords_2EEXISTS__HB,axiom,
    ! [A_27a: $tType] :
    ? [V0m: tyop_2Enum_2Enum] :
      ( ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
      = ( c_2Enum_2ESUC @ V0m ) ) ).

thf(thm_2Ewords_2EMOD__DIMINDEX,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Earithmetic_2EMOD @ V0n @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
      = ( c_2Ebit_2EBITS @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ c_2Enum_2E0 @ V0n ) ) ).

thf(thm_2Ewords_2EBITS__ZEROL__DIMINDEX,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V0n @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
     => ( ( c_2Ebit_2EBITS @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ c_2Enum_2E0 @ V0n )
        = V0n ) ) ).

thf(thm_2Ewords_2EMOD__2EXP__DIMINDEX,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Earithmetic_2EMOD @ V0n @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
      = ( c_2Ebit_2EMOD__2EXP @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ V0n ) ) ).

thf(thm_2Ewords_2EINT__MIN__SUM,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ( c_2Ewords_2EINT__MIN @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) @ ( c_2Ebool_2Ethe__value @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) ) )
      = ( c_2Ebool_2ECOND @ tyop_2Enum_2Enum @ ( c_2Ebool_2E_2F_5C @ ( c_2Epred__set_2EFINITE @ A_27a @ ( c_2Epred__set_2EUNIV @ A_27a ) ) @ ( c_2Epred__set_2EFINITE @ A_27b @ ( c_2Epred__set_2EUNIV @ A_27b ) ) ) @ ( c_2Earithmetic_2E_2A @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2EINT__MIN @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) @ ( c_2Ewords_2EINT__MIN @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) @ ( c_2Ebool_2Ethe__value @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) ) ) ) ) ).

thf(thm_2Ewords_2EZERO__LT__INT__MIN,axiom,
    ! [A_27a: $tType] : ( c_2Eprim__rec_2E_3C @ c_2Enum_2E0 @ ( c_2Ewords_2EINT__MIN @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ).

thf(thm_2Ewords_2EZERO__LT__INT__MAX,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Eprim__rec_2E_3C @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
     => ( c_2Eprim__rec_2E_3C @ c_2Enum_2E0 @ ( c_2Ewords_2EINT__MAX @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ).

thf(thm_2Ewords_2EZERO__LE__INT__MAX,axiom,
    ! [A_27a: $tType] : ( c_2Earithmetic_2E_3C_3D @ c_2Enum_2E0 @ ( c_2Ewords_2EINT__MAX @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ).

thf(thm_2Ewords_2EZERO__LT__UINT__MAX,axiom,
    ! [A_27a: $tType] : ( c_2Eprim__rec_2E_3C @ c_2Enum_2E0 @ ( c_2Ewords_2EUINT__MAX @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ).

thf(thm_2Ewords_2EINT__MIN__LT__DIMWORD,axiom,
    ! [A_27a: $tType] : ( c_2Eprim__rec_2E_3C @ ( c_2Ewords_2EINT__MIN @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ).

thf(thm_2Ewords_2EINT__MAX__LT__DIMWORD,axiom,
    ! [A_27a: $tType] : ( c_2Eprim__rec_2E_3C @ ( c_2Ewords_2EINT__MAX @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ).

thf(thm_2Ewords_2Edimindex__lt__dimword,axiom,
    ! [A_27a: $tType] : ( c_2Eprim__rec_2E_3C @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ).

thf(thm_2Ewords_2EBOUND__ORDER,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Eprim__rec_2E_3C @ ( c_2Ewords_2EINT__MAX @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2EINT__MIN @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
      & ( c_2Earithmetic_2E_3C_3D @ ( c_2Ewords_2EINT__MIN @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2EUINT__MAX @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
      & ( c_2Eprim__rec_2E_3C @ ( c_2Ewords_2EUINT__MAX @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ).

thf(thm_2Ewords_2Edimindex__dimword__iso,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ( ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
        = ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) )
    <=> ( ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
        = ( c_2Ewords_2Edimword @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) ) ).

thf(thm_2Ewords_2Edimindex__dimword__le__iso,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ( c_2Earithmetic_2E_3C_3D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) )
      = ( c_2Earithmetic_2E_3C_3D @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2Edimword @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) ) ).

thf(thm_2Ewords_2Edimindex__dimword__lt__iso,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ( c_2Eprim__rec_2E_3C @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) )
      = ( c_2Eprim__rec_2E_3C @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2Edimword @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) ) ).

thf(thm_2Ewords_2Edimindex__int__min__iso,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ( ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
        = ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) )
    <=> ( ( c_2Ewords_2EINT__MIN @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
        = ( c_2Ewords_2EINT__MIN @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) ) ).

thf(thm_2Ewords_2Edimindex__int__min__le__iso,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ( c_2Earithmetic_2E_3C_3D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) )
      = ( c_2Earithmetic_2E_3C_3D @ ( c_2Ewords_2EINT__MIN @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2EINT__MIN @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) ) ).

thf(thm_2Ewords_2Edimindex__int__min__lt__iso,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ( c_2Eprim__rec_2E_3C @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) )
      = ( c_2Eprim__rec_2E_3C @ ( c_2Ewords_2EINT__MIN @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2EINT__MIN @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) ) ).

thf(thm_2Ewords_2Edimindex__int__max__iso,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ( ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
        = ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) )
    <=> ( ( c_2Ewords_2EINT__MAX @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
        = ( c_2Ewords_2EINT__MAX @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) ) ).

thf(thm_2Ewords_2Edimindex__int__max__le__iso,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ( c_2Earithmetic_2E_3C_3D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) )
      = ( c_2Earithmetic_2E_3C_3D @ ( c_2Ewords_2EINT__MAX @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2EINT__MAX @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) ) ).

thf(thm_2Ewords_2Edimindex__int__max__lt__iso,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ( c_2Eprim__rec_2E_3C @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) )
      = ( c_2Eprim__rec_2E_3C @ ( c_2Ewords_2EINT__MAX @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2EINT__MAX @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) ) ).

thf(thm_2Ewords_2Edimindex__uint__max__iso,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ( ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
        = ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) )
    <=> ( ( c_2Ewords_2EUINT__MAX @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
        = ( c_2Ewords_2EUINT__MAX @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) ) ).

thf(thm_2Ewords_2Edimindex__uint__max__le__iso,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ( c_2Earithmetic_2E_3C_3D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) )
      = ( c_2Earithmetic_2E_3C_3D @ ( c_2Ewords_2EUINT__MAX @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2EUINT__MAX @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) ) ).

thf(thm_2Ewords_2Edimindex__uint__max__lt__iso,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ( c_2Eprim__rec_2E_3C @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) )
      = ( c_2Eprim__rec_2E_3C @ ( c_2Ewords_2EUINT__MAX @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2EUINT__MAX @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) ) ).

thf(thm_2Ewords_2Ew2n__n2w,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Ew2n @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) )
      = ( c_2Earithmetic_2EMOD @ V0n @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ).

thf(thm_2Ewords_2En2w__w2n,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2En2w @ A_27a @ ( c_2Ewords_2Ew2n @ A_27a @ V0w ) )
      = V0w ) ).

thf(thm_2Ewords_2Eword__nchotomy,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
    ? [V1n: tyop_2Enum_2Enum] :
      ( V0w
      = ( c_2Ewords_2En2w @ A_27a @ V1n ) ) ).

thf(thm_2Ewords_2En2w__mod,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2EMOD @ V0n @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) )
      = ( c_2Ewords_2En2w @ A_27a @ V0n ) ) ).

thf(thm_2Ewords_2En2w__11,axiom,
    ! [A_27a: $tType,V0m: tyop_2Enum_2Enum,V1n: tyop_2Enum_2Enum] :
      ( ( ( c_2Ewords_2En2w @ A_27a @ V0m )
        = ( c_2Ewords_2En2w @ A_27a @ V1n ) )
    <=> ( ( c_2Earithmetic_2EMOD @ V0m @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
        = ( c_2Earithmetic_2EMOD @ V1n @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ).

thf(thm_2Ewords_2Eranged__word__nchotomy,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
    ? [V1n: tyop_2Enum_2Enum] :
      ( ( V0w
        = ( c_2Ewords_2En2w @ A_27a @ V1n ) )
      & ( c_2Eprim__rec_2E_3C @ V1n @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ).

thf(thm_2Ewords_2Edimindex__1__cases,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
        = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) )
     => ( ( V0a
          = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
        | ( V0a
          = ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(thm_2Ewords_2Emod__dimindex,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] : ( c_2Eprim__rec_2E_3C @ ( c_2Earithmetic_2EMOD @ V0n @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ).

thf(thm_2Ewords_2EWORD__INDUCT,axiom,
    ! [A_27a: $tType,V0P: ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > $o] :
      ( ( ( V0P @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
        & ! [V1n: tyop_2Enum_2Enum] :
            ( ( c_2Eprim__rec_2E_3C @ ( c_2Enum_2ESUC @ V1n ) @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
           => ( ( V0P @ ( c_2Ewords_2En2w @ A_27a @ V1n ) )
             => ( V0P @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Enum_2ESUC @ V1n ) ) ) ) ) )
     => ! [V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] : ( V0P @ V2x ) ) ).

thf(thm_2Ewords_2Ew2n__11,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Ew2n @ A_27a @ V0v )
        = ( c_2Ewords_2Ew2n @ A_27a @ V1w ) )
    <=> ( V0v = V1w ) ) ).

thf(thm_2Ewords_2Ew2n__lt,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] : ( c_2Eprim__rec_2E_3C @ ( c_2Ewords_2Ew2n @ A_27a @ V0w ) @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ).

thf(thm_2Ewords_2Eword__0__n2w,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Ew2n @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
      = c_2Enum_2E0 ) ).

thf(thm_2Ewords_2Eword__1__n2w,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Ew2n @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ).

thf(thm_2Ewords_2Ew2n__eq__0,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Ew2n @ A_27a @ V0w )
        = c_2Enum_2E0 )
    <=> ( V0w
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ewords_2En2w__dimword,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2En2w @ A_27a @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
      = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ).

thf(thm_2Ewords_2Eword__2comp__dimindex__1,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
        = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) )
     => ( ( c_2Ewords_2Eword__2comp @ A_27a @ V0w )
        = V0w ) ) ).

thf(thm_2Ewords_2Eword__add__n2w,axiom,
    ! [A_27a: $tType,V0m: tyop_2Enum_2Enum,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0m ) @ ( c_2Ewords_2En2w @ A_27a @ V1n ) )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2E_2B @ V0m @ V1n ) ) ) ).

thf(thm_2Ewords_2Eword__mul__n2w,axiom,
    ! [A_27a: $tType,V0m: tyop_2Enum_2Enum,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__mul @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0m ) @ ( c_2Ewords_2En2w @ A_27a @ V1n ) )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2E_2A @ V0m @ V1n ) ) ) ).

thf(thm_2Ewords_2Eword__log2__n2w,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__log2 @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Ebit_2ELOG2 @ ( c_2Earithmetic_2EMOD @ V0n @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__1comp__n2w,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2D @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Earithmetic_2EMOD @ V0n @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__2comp__n2w,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2E_2D @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2EMOD @ V0n @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__lsb,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__lsb @ A_27a )
      = ( c_2Ewords_2Eword__bit @ A_27a @ c_2Enum_2E0 ) ) ).

thf(thm_2Ewords_2Eword__msb,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__msb @ A_27a )
      = ( c_2Ewords_2Eword__bit @ A_27a @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__lsb__n2w,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__lsb @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) )
      = ( c_2Earithmetic_2EODD @ V0n ) ) ).

thf(thm_2Ewords_2Eword__msb__n2w,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__msb @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) )
      = ( c_2Ebit_2EBIT @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V0n ) ) ).

thf(thm_2Ewords_2Eword__msb__n2w__numeric,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__msb @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) )
      = ( c_2Earithmetic_2E_3C_3D @ ( c_2Ewords_2EINT__MIN @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2EMOD @ V0n @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__and__n2w,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum,V1m: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__and @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) @ ( c_2Ewords_2En2w @ A_27a @ V1m ) )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Ebit_2EBITWISE @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ c_2Ebool_2E_2F_5C @ V0n @ V1m ) ) ) ).

thf(thm_2Ewords_2Eword__or__n2w,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum,V1m: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__or @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) @ ( c_2Ewords_2En2w @ A_27a @ V1m ) )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Ebit_2EBITWISE @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ c_2Ebool_2E_5C_2F @ V0n @ V1m ) ) ) ).

thf(thm_2Ewords_2Eword__xor__n2w,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum,V1m: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__xor @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) @ ( c_2Ewords_2En2w @ A_27a @ V1m ) )
      = ( c_2Ewords_2En2w @ A_27a
        @ ( c_2Ebit_2EBITWISE @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
          @ ^ [V2x: $o,V3y: $o] : ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ $o @ V2x @ V3y ) )
          @ V0n
          @ V1m ) ) ) ).

thf(thm_2Ewords_2Eword__nand__n2w,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum,V1m: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__nand @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) @ ( c_2Ewords_2En2w @ A_27a @ V1m ) )
      = ( c_2Ewords_2En2w @ A_27a
        @ ( c_2Ebit_2EBITWISE @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
          @ ^ [V2x: $o,V3y: $o] : ( c_2Ebool_2E_7E @ ( c_2Ebool_2E_2F_5C @ V2x @ V3y ) )
          @ V0n
          @ V1m ) ) ) ).

thf(thm_2Ewords_2Eword__nor__n2w,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum,V1m: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__nor @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) @ ( c_2Ewords_2En2w @ A_27a @ V1m ) )
      = ( c_2Ewords_2En2w @ A_27a
        @ ( c_2Ebit_2EBITWISE @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) )
          @ ^ [V2x: $o,V3y: $o] : ( c_2Ebool_2E_7E @ ( c_2Ebool_2E_5C_2F @ V2x @ V3y ) )
          @ V0n
          @ V1m ) ) ) ).

thf(thm_2Ewords_2Eword__xnor__n2w,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum,V1m: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__xnor @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) @ ( c_2Ewords_2En2w @ A_27a @ V1m ) )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Ebit_2EBITWISE @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Emin_2E_3D @ $o ) @ V0n @ V1m ) ) ) ).

thf(thm_2Ewords_2El2w__w2l,axiom,
    ! [A_27a: $tType,V0b: tyop_2Enum_2Enum,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Eprim__rec_2E_3C @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ V0b )
     => ( ( c_2Ewords_2El2w @ A_27a @ V0b @ ( c_2Ewords_2Ew2l @ A_27a @ V0b @ V1w ) )
        = V1w ) ) ).

thf(thm_2Ewords_2Ew2l__l2w,axiom,
    ! [A_27a: $tType,V0b: tyop_2Enum_2Enum,V1l: tyop_2Elist_2Elist @ tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Ew2l @ A_27a @ V0b @ ( c_2Ewords_2El2w @ A_27a @ V0b @ V1l ) )
      = ( c_2Enumposrep_2En2l @ V0b @ ( c_2Earithmetic_2EMOD @ ( c_2Enumposrep_2El2n @ V0b @ V1l ) @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ).

thf(thm_2Ewords_2Es2w__w2s,axiom,
    ! [A_27a: $tType,V0c2n: tyop_2Estring_2Echar > tyop_2Enum_2Enum,V1n2c: tyop_2Enum_2Enum > tyop_2Estring_2Echar,V2b: tyop_2Enum_2Enum,V3w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Eprim__rec_2E_3C @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ V2b )
        & ! [V4x: tyop_2Enum_2Enum] :
            ( ( c_2Eprim__rec_2E_3C @ V4x @ V2b )
           => ( ( V0c2n @ ( V1n2c @ V4x ) )
              = V4x ) ) )
     => ( ( c_2Ewords_2Es2w @ A_27a @ V2b @ V0c2n @ ( c_2Ewords_2Ew2s @ A_27a @ V2b @ V1n2c @ V3w ) )
        = V3w ) ) ).

thf(thm_2Ewords_2Ew2s__s2w,axiom,
    ! [A_27a: $tType,V0b: tyop_2Enum_2Enum,V1c2n: tyop_2Estring_2Echar > tyop_2Enum_2Enum,V2n2c: tyop_2Enum_2Enum > tyop_2Estring_2Echar,V3s: tyop_2Elist_2Elist @ tyop_2Estring_2Echar] :
      ( ( c_2Ewords_2Ew2s @ A_27a @ V0b @ V2n2c @ ( c_2Ewords_2Es2w @ A_27a @ V0b @ V1c2n @ V3s ) )
      = ( c_2EASCIInumbers_2En2s @ V0b @ V2n2c @ ( c_2Earithmetic_2EMOD @ ( c_2EASCIInumbers_2Es2n @ V0b @ V1c2n @ V3s ) @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ).

thf(thm_2Ewords_2ENUMERAL__LESS__THM,axiom,
    ( ! [V0m: tyop_2Enum_2Enum,V1n: tyop_2Enum_2Enum] :
        ( ( c_2Eprim__rec_2E_3C @ V0m @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ V1n ) ) )
      <=> ( ( V0m
            = ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ V1n ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
          | ( c_2Eprim__rec_2E_3C @ V0m @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ V1n ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) )
    & ! [V2m: tyop_2Enum_2Enum,V3n: tyop_2Enum_2Enum] :
        ( ( c_2Eprim__rec_2E_3C @ V2m @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ V3n ) ) )
      <=> ( ( V2m
            = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ V3n ) ) )
          | ( c_2Eprim__rec_2E_3C @ V2m @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ V3n ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__bin__list,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Elist_2Elist @ tyop_2Enum_2Enum ) @ ( c_2Ewords_2Eword__from__bin__list @ A_27a ) @ ( c_2Ewords_2Eword__to__bin__list @ A_27a ) )
      = ( c_2Ecombin_2EI @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ) ).

thf(thm_2Ewords_2Eword__oct__list,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Elist_2Elist @ tyop_2Enum_2Enum ) @ ( c_2Ewords_2Eword__from__oct__list @ A_27a ) @ ( c_2Ewords_2Eword__to__oct__list @ A_27a ) )
      = ( c_2Ecombin_2EI @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ) ).

thf(thm_2Ewords_2Eword__dec__list,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Elist_2Elist @ tyop_2Enum_2Enum ) @ ( c_2Ewords_2Eword__from__dec__list @ A_27a ) @ ( c_2Ewords_2Eword__to__dec__list @ A_27a ) )
      = ( c_2Ecombin_2EI @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ) ).

thf(thm_2Ewords_2Eword__hex__list,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Elist_2Elist @ tyop_2Enum_2Enum ) @ ( c_2Ewords_2Eword__from__hex__list @ A_27a ) @ ( c_2Ewords_2Eword__to__hex__list @ A_27a ) )
      = ( c_2Ecombin_2EI @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ) ).

thf(thm_2Ewords_2Eword__bin__string,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Elist_2Elist @ tyop_2Estring_2Echar ) @ ( c_2Ewords_2Eword__from__bin__string @ A_27a ) @ ( c_2Ewords_2Eword__to__bin__string @ A_27a ) )
      = ( c_2Ecombin_2EI @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ) ).

thf(thm_2Ewords_2Eword__oct__string,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Elist_2Elist @ tyop_2Estring_2Echar ) @ ( c_2Ewords_2Eword__from__oct__string @ A_27a ) @ ( c_2Ewords_2Eword__to__oct__string @ A_27a ) )
      = ( c_2Ecombin_2EI @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ) ).

thf(thm_2Ewords_2Eword__dec__string,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Elist_2Elist @ tyop_2Estring_2Echar ) @ ( c_2Ewords_2Eword__from__dec__string @ A_27a ) @ ( c_2Ewords_2Eword__to__dec__string @ A_27a ) )
      = ( c_2Ecombin_2EI @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ) ).

thf(thm_2Ewords_2Eword__hex__string,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( tyop_2Elist_2Elist @ tyop_2Estring_2Echar ) @ ( c_2Ewords_2Eword__from__hex__string @ A_27a ) @ ( c_2Ewords_2Eword__to__hex__string @ A_27a ) )
      = ( c_2Ecombin_2EI @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ) ).

thf(thm_2Ewords_2Eword__0,axiom,
    ! [A_27a: $tType,V0i: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V0i @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
     => ( (~) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) @ V0i ) ) ) ).

thf(thm_2Ewords_2Eword__eq__0,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( V0w
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
    <=> ! [V1i: tyop_2Enum_2Enum] :
          ( ( c_2Eprim__rec_2E_3C @ V1i @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
         => ( (~) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0w @ V1i ) ) ) ) ).

thf(thm_2Ewords_2Eword__T,axiom,
    ! [A_27a: $tType,V0i: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V0i @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
     => ( c_2Efcp_2Efcp__index @ $o @ A_27a @ ( c_2Ewords_2Eword__T @ A_27a ) @ V0i ) ) ).

thf(thm_2Ewords_2EFCP__T__F,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ( ( c_2Efcp_2EFCP @ $o @ A_27a @ ( c_2Ecombin_2EK @ $o @ tyop_2Enum_2Enum @ c_2Ebool_2ET ) )
        = ( c_2Ewords_2Eword__T @ A_27a ) )
      & ( ( c_2Efcp_2EFCP @ $o @ A_27b @ ( c_2Ecombin_2EK @ $o @ tyop_2Enum_2Enum @ c_2Ebool_2EF ) )
        = ( c_2Ewords_2En2w @ A_27b @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ewords_2Eword__L,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V0n @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
     => ( ( c_2Efcp_2Efcp__index @ $o @ A_27a @ ( c_2Ewords_2Eword__L @ A_27a ) @ V0n )
      <=> ( V0n
          = ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__H,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V0n @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
     => ( ( c_2Efcp_2Efcp__index @ $o @ A_27a @ ( c_2Ewords_2Eword__H @ A_27a ) @ V0n )
        = ( c_2Eprim__rec_2E_3C @ V0n @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__L2,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__L2 @ A_27a )
      = ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( c_2Eprim__rec_2E_3C @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) @ ( c_2Ewords_2Eword__L @ A_27a ) ) ) ).

thf(thm_2Ewords_2EWORD__NEG__1,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      = ( c_2Ewords_2Eword__T @ A_27a ) ) ).

thf(thm_2Ewords_2EWORD__NEG__1__T,axiom,
    ! [A_27a: $tType,V0i: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V0i @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
     => ( c_2Efcp_2Efcp__index @ $o @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ V0i ) ) ).

thf(thm_2Ewords_2EWORD__MSB__1COMP,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__msb @ A_27a @ ( c_2Ewords_2Eword__1comp @ A_27a @ V0w ) )
    <=> ( (~) @ ( c_2Ewords_2Eword__msb @ A_27a @ V0w ) ) ) ).

thf(thm_2Ewords_2Ew2n__minus1,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Ew2n @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
      = ( c_2Earithmetic_2E_2D @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Ewords_2Ew2n__plus1,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Earithmetic_2E_2B @ ( c_2Ewords_2Ew2n @ A_27a @ V0a ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) )
      = ( c_2Ebool_2ECOND @ tyop_2Enum_2Enum @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ V0a @ ( c_2Ewords_2Eword__T @ A_27a ) ) @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ewords_2Ew2n @ A_27a @ ( c_2Ewords_2Eword__add @ A_27a @ V0a @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ).

thf(thm_2Ewords_2EWORD__NOT__NOT,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2Eword__1comp @ A_27a @ V0a ) )
      = V0a ) ).

thf(thm_2Ewords_2EWORD__DE__MORGAN__THM,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2Eword__and @ A_27a @ V0a @ V1b ) )
        = ( c_2Ewords_2Eword__or @ A_27a @ ( c_2Ewords_2Eword__1comp @ A_27a @ V0a ) @ ( c_2Ewords_2Eword__1comp @ A_27a @ V1b ) ) )
      & ( ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2Eword__or @ A_27a @ V0a @ V1b ) )
        = ( c_2Ewords_2Eword__and @ A_27a @ ( c_2Ewords_2Eword__1comp @ A_27a @ V0a ) @ ( c_2Ewords_2Eword__1comp @ A_27a @ V1b ) ) ) ) ).

thf(thm_2Ewords_2EWORD__NOT__XOR,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__xor @ A_27a @ ( c_2Ewords_2Eword__1comp @ A_27a @ V0a ) @ ( c_2Ewords_2Eword__1comp @ A_27a @ V1b ) )
        = ( c_2Ewords_2Eword__xor @ A_27a @ V0a @ V1b ) )
      & ( ( c_2Ewords_2Eword__xor @ A_27a @ V0a @ ( c_2Ewords_2Eword__1comp @ A_27a @ V1b ) )
        = ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2Eword__xor @ A_27a @ V0a @ V1b ) ) )
      & ( ( c_2Ewords_2Eword__xor @ A_27a @ ( c_2Ewords_2Eword__1comp @ A_27a @ V0a ) @ V1b )
        = ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2Eword__xor @ A_27a @ V0a @ V1b ) ) ) ) ).

thf(thm_2Ewords_2EWORD__AND__CLAUSES,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__and @ A_27a @ ( c_2Ewords_2Eword__T @ A_27a ) @ V0a )
        = V0a )
      & ( ( c_2Ewords_2Eword__and @ A_27a @ V0a @ ( c_2Ewords_2Eword__T @ A_27a ) )
        = V0a )
      & ( ( c_2Ewords_2Eword__and @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) @ V0a )
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
      & ( ( c_2Ewords_2Eword__and @ A_27a @ V0a @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
      & ( ( c_2Ewords_2Eword__and @ A_27a @ V0a @ V0a )
        = V0a ) ) ).

thf(thm_2Ewords_2EWORD__OR__CLAUSES,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__or @ A_27a @ ( c_2Ewords_2Eword__T @ A_27a ) @ V0a )
        = ( c_2Ewords_2Eword__T @ A_27a ) )
      & ( ( c_2Ewords_2Eword__or @ A_27a @ V0a @ ( c_2Ewords_2Eword__T @ A_27a ) )
        = ( c_2Ewords_2Eword__T @ A_27a ) )
      & ( ( c_2Ewords_2Eword__or @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) @ V0a )
        = V0a )
      & ( ( c_2Ewords_2Eword__or @ A_27a @ V0a @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
        = V0a )
      & ( ( c_2Ewords_2Eword__or @ A_27a @ V0a @ V0a )
        = V0a ) ) ).

thf(thm_2Ewords_2EWORD__XOR__CLAUSES,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__xor @ A_27a @ ( c_2Ewords_2Eword__T @ A_27a ) @ V0a )
        = ( c_2Ewords_2Eword__1comp @ A_27a @ V0a ) )
      & ( ( c_2Ewords_2Eword__xor @ A_27a @ V0a @ ( c_2Ewords_2Eword__T @ A_27a ) )
        = ( c_2Ewords_2Eword__1comp @ A_27a @ V0a ) )
      & ( ( c_2Ewords_2Eword__xor @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) @ V0a )
        = V0a )
      & ( ( c_2Ewords_2Eword__xor @ A_27a @ V0a @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
        = V0a )
      & ( ( c_2Ewords_2Eword__xor @ A_27a @ V0a @ V0a )
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ewords_2EWORD__AND__ASSOC,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a,V2c: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__and @ A_27a @ ( c_2Ewords_2Eword__and @ A_27a @ V0a @ V1b ) @ V2c )
      = ( c_2Ewords_2Eword__and @ A_27a @ V0a @ ( c_2Ewords_2Eword__and @ A_27a @ V1b @ V2c ) ) ) ).

thf(thm_2Ewords_2EWORD__OR__ASSOC,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a,V2c: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__or @ A_27a @ ( c_2Ewords_2Eword__or @ A_27a @ V0a @ V1b ) @ V2c )
      = ( c_2Ewords_2Eword__or @ A_27a @ V0a @ ( c_2Ewords_2Eword__or @ A_27a @ V1b @ V2c ) ) ) ).

thf(thm_2Ewords_2EWORD__XOR__ASSOC,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a,V2c: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__xor @ A_27a @ ( c_2Ewords_2Eword__xor @ A_27a @ V0a @ V1b ) @ V2c )
      = ( c_2Ewords_2Eword__xor @ A_27a @ V0a @ ( c_2Ewords_2Eword__xor @ A_27a @ V1b @ V2c ) ) ) ).

thf(thm_2Ewords_2EWORD__AND__COMM,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__and @ A_27a @ V0a @ V1b )
      = ( c_2Ewords_2Eword__and @ A_27a @ V1b @ V0a ) ) ).

thf(thm_2Ewords_2EWORD__OR__COMM,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__or @ A_27a @ V0a @ V1b )
      = ( c_2Ewords_2Eword__or @ A_27a @ V1b @ V0a ) ) ).

thf(thm_2Ewords_2EWORD__XOR__COMM,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__xor @ A_27a @ V0a @ V1b )
      = ( c_2Ewords_2Eword__xor @ A_27a @ V1b @ V0a ) ) ).

thf(thm_2Ewords_2EWORD__AND__IDEM,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__and @ A_27a @ V0a @ V0a )
      = V0a ) ).

thf(thm_2Ewords_2EWORD__OR__IDEM,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__or @ A_27a @ V0a @ V0a )
      = V0a ) ).

thf(thm_2Ewords_2EWORD__AND__ABSORD,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__or @ A_27a @ V0a @ ( c_2Ewords_2Eword__and @ A_27a @ V0a @ V1b ) )
      = V0a ) ).

thf(thm_2Ewords_2EWORD__OR__ABSORB,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__and @ A_27a @ V0a @ ( c_2Ewords_2Eword__or @ A_27a @ V0a @ V1b ) )
      = V0a ) ).

thf(thm_2Ewords_2EWORD__AND__COMP,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__and @ A_27a @ V0a @ ( c_2Ewords_2Eword__1comp @ A_27a @ V0a ) )
      = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ).

thf(thm_2Ewords_2EWORD__OR__COMP,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__or @ A_27a @ V0a @ ( c_2Ewords_2Eword__1comp @ A_27a @ V0a ) )
      = ( c_2Ewords_2Eword__T @ A_27a ) ) ).

thf(thm_2Ewords_2EWORD__XOR__COMP,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__xor @ A_27a @ V0a @ ( c_2Ewords_2Eword__1comp @ A_27a @ V0a ) )
      = ( c_2Ewords_2Eword__T @ A_27a ) ) ).

thf(thm_2Ewords_2EWORD__RIGHT__AND__OVER__OR,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a,V2c: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__and @ A_27a @ ( c_2Ewords_2Eword__or @ A_27a @ V0a @ V1b ) @ V2c )
      = ( c_2Ewords_2Eword__or @ A_27a @ ( c_2Ewords_2Eword__and @ A_27a @ V0a @ V2c ) @ ( c_2Ewords_2Eword__and @ A_27a @ V1b @ V2c ) ) ) ).

thf(thm_2Ewords_2EWORD__RIGHT__OR__OVER__AND,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a,V2c: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__or @ A_27a @ ( c_2Ewords_2Eword__and @ A_27a @ V0a @ V1b ) @ V2c )
      = ( c_2Ewords_2Eword__and @ A_27a @ ( c_2Ewords_2Eword__or @ A_27a @ V0a @ V2c ) @ ( c_2Ewords_2Eword__or @ A_27a @ V1b @ V2c ) ) ) ).

thf(thm_2Ewords_2EWORD__RIGHT__AND__OVER__XOR,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a,V2c: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__and @ A_27a @ ( c_2Ewords_2Eword__xor @ A_27a @ V0a @ V1b ) @ V2c )
      = ( c_2Ewords_2Eword__xor @ A_27a @ ( c_2Ewords_2Eword__and @ A_27a @ V0a @ V2c ) @ ( c_2Ewords_2Eword__and @ A_27a @ V1b @ V2c ) ) ) ).

thf(thm_2Ewords_2EWORD__LEFT__AND__OVER__OR,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a,V2c: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__and @ A_27a @ V0a @ ( c_2Ewords_2Eword__or @ A_27a @ V1b @ V2c ) )
      = ( c_2Ewords_2Eword__or @ A_27a @ ( c_2Ewords_2Eword__and @ A_27a @ V0a @ V1b ) @ ( c_2Ewords_2Eword__and @ A_27a @ V0a @ V2c ) ) ) ).

thf(thm_2Ewords_2EWORD__LEFT__OR__OVER__AND,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a,V2c: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__or @ A_27a @ V0a @ ( c_2Ewords_2Eword__and @ A_27a @ V1b @ V2c ) )
      = ( c_2Ewords_2Eword__and @ A_27a @ ( c_2Ewords_2Eword__or @ A_27a @ V0a @ V1b ) @ ( c_2Ewords_2Eword__or @ A_27a @ V0a @ V2c ) ) ) ).

thf(thm_2Ewords_2EWORD__LEFT__AND__OVER__XOR,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a,V2c: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__and @ A_27a @ V0a @ ( c_2Ewords_2Eword__xor @ A_27a @ V1b @ V2c ) )
      = ( c_2Ewords_2Eword__xor @ A_27a @ ( c_2Ewords_2Eword__and @ A_27a @ V0a @ V1b ) @ ( c_2Ewords_2Eword__and @ A_27a @ V0a @ V2c ) ) ) ).

thf(thm_2Ewords_2EWORD__XOR,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__xor @ A_27a @ V0a @ V1b )
      = ( c_2Ewords_2Eword__or @ A_27a @ ( c_2Ewords_2Eword__and @ A_27a @ V0a @ ( c_2Ewords_2Eword__1comp @ A_27a @ V1b ) ) @ ( c_2Ewords_2Eword__and @ A_27a @ V1b @ ( c_2Ewords_2Eword__1comp @ A_27a @ V0a ) ) ) ) ).

thf(thm_2Ewords_2EWORD__NAND__NOT__AND,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__nand @ A_27a @ V0a @ V1b )
      = ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2Eword__and @ A_27a @ V0a @ V1b ) ) ) ).

thf(thm_2Ewords_2EWORD__NOR__NOT__OR,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__nor @ A_27a @ V0a @ V1b )
      = ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2Eword__or @ A_27a @ V0a @ V1b ) ) ) ).

thf(thm_2Ewords_2EWORD__XNOR__NOT__XOR,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__xnor @ A_27a @ V0a @ V1b )
      = ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2Eword__xor @ A_27a @ V0a @ V1b ) ) ) ).

thf(thm_2Ewords_2EWORD__ADD__OR,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__and @ A_27a @ V0a @ V1b )
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
     => ( ( c_2Ewords_2Eword__add @ A_27a @ V0a @ V1b )
        = ( c_2Ewords_2Eword__or @ A_27a @ V0a @ V1b ) ) ) ).

thf(thm_2Ewords_2EWORD__ADD__XOR,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__and @ A_27a @ V0a @ V1b )
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
     => ( ( c_2Ewords_2Eword__add @ A_27a @ V0a @ V1b )
        = ( c_2Ewords_2Eword__xor @ A_27a @ V0a @ V1b ) ) ) ).

thf(thm_2Ewords_2EWORD__AND__EXP__SUB1,axiom,
    ! [A_27a: $tType,V0m: tyop_2Enum_2Enum,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__and @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V1n ) @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2EEXP @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) @ V0m ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2EMOD @ V1n @ ( c_2Earithmetic_2EEXP @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) @ V0m ) ) ) ) ).

thf(thm_2Ewords_2Eword__msb__add__word__L,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__msb @ A_27a @ ( c_2Ewords_2Eword__add @ A_27a @ V0a @ ( c_2Ewords_2Eword__L @ A_27a ) ) )
    <=> ( (~) @ ( c_2Ewords_2Eword__msb @ A_27a @ V0a ) ) ) ).

thf(thm_2Ewords_2Ew2w,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1i: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V1i @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) )
     => ( ( c_2Efcp_2Efcp__index @ $o @ A_27b @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V0w ) @ V1i )
      <=> ( ( c_2Eprim__rec_2E_3C @ V1i @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
          & ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0w @ V1i ) ) ) ) ).

thf(thm_2Ewords_2Esw2sw,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1i: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V1i @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) )
     => ( ( c_2Efcp_2Efcp__index @ $o @ A_27b @ ( c_2Ewords_2Esw2sw @ A_27a @ A_27b @ V0w ) @ V1i )
        = ( c_2Ebool_2ECOND @ $o @ ( c_2Ebool_2E_5C_2F @ ( c_2Eprim__rec_2E_3C @ V1i @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) @ ( c_2Eprim__rec_2E_3C @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0w @ V1i ) @ ( c_2Ewords_2Eword__msb @ A_27a @ V0w ) ) ) ) ).

thf(thm_2Ewords_2Ew2w__id,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ew2w @ A_27a @ A_27a @ V0w )
      = V0w ) ).

thf(thm_2Ewords_2Esw2sw__id,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Esw2sw @ A_27a @ A_27a @ V0w )
      = V0w ) ).

thf(thm_2Ewords_2Ew2w__w2w,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ew2w @ A_27b @ A_27c @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V0w ) )
      = ( c_2Ewords_2Ew2w @ A_27a @ A_27c @ ( c_2Ewords_2Eword__bits @ A_27a @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ c_2Enum_2E0 @ V0w ) ) ) ).

thf(thm_2Ewords_2Esw2sw__sw2sw,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Esw2sw @ A_27b @ A_27c @ ( c_2Ewords_2Esw2sw @ A_27a @ A_27b @ V0w ) )
      = ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27c ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Eprim__rec_2E_3C @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) @ ( c_2Eprim__rec_2E_3C @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ ( c_2Efcp_2Edimindex @ A_27c @ ( c_2Ebool_2Ethe__value @ A_27c ) ) ) ) @ ( c_2Ewords_2Esw2sw @ A_27b @ A_27c @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V0w ) ) @ ( c_2Ewords_2Esw2sw @ A_27a @ A_27c @ V0w ) ) ) ).

thf(thm_2Ewords_2Esw2sw__w2w,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Esw2sw @ A_27a @ A_27b @ V0w )
      = ( c_2Ewords_2Eword__or @ A_27b @ ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27b ) @ ( c_2Ewords_2Eword__msb @ A_27a @ V0w ) @ ( c_2Ewords_2Eword__lsl @ A_27b @ ( c_2Ewords_2Eword__2comp @ A_27b @ ( c_2Ewords_2En2w @ A_27b @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) @ ( c_2Ewords_2En2w @ A_27b @ c_2Enum_2E0 ) ) @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V0w ) ) ) ).

thf(thm_2Ewords_2Eword__bit,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V1b @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
     => ( ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0w @ V1b )
        = ( c_2Ewords_2Eword__bit @ A_27a @ V1b @ V0w ) ) ) ).

thf(thm_2Ewords_2Eword__slice__n2w,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__slice @ A_27a @ V0h @ V1l @ ( c_2Ewords_2En2w @ A_27a @ V2n ) )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Ebit_2ESLICE @ ( c_2Earithmetic_2EMIN @ V0h @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ V1l @ V2n ) ) ) ).

thf(thm_2Ewords_2Eword__bits__n2w,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ V1l @ ( c_2Ewords_2En2w @ A_27a @ V2n ) )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Ebit_2EBITS @ ( c_2Earithmetic_2EMIN @ V0h @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ V1l @ V2n ) ) ) ).

thf(thm_2Ewords_2Eword__bit__n2w,axiom,
    ! [A_27a: $tType,V0b: tyop_2Enum_2Enum,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__bit @ A_27a @ V0b @ ( c_2Ewords_2En2w @ A_27a @ V1n ) )
    <=> ( ( c_2Earithmetic_2E_3C_3D @ V0b @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
        & ( c_2Ebit_2EBIT @ V0b @ V1n ) ) ) ).

thf(thm_2Ewords_2Eword__signed__bits__n2w,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__signed__bits @ A_27a @ V0h @ V1l @ ( c_2Ewords_2En2w @ A_27a @ V2n ) )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Ebit_2ESIGN__EXTEND @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2EMIN @ ( c_2Enum_2ESUC @ V0h ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) @ V1l ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Ebit_2EBITS @ ( c_2Earithmetic_2EMIN @ V0h @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ V1l @ V2n ) ) ) ) ).

thf(thm_2Ewords_2Eword__sign__extend__bits,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__signed__bits @ A_27a @ V0h @ V1l @ V2w )
      = ( c_2Ewords_2Eword__sign__extend @ A_27a @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2EMIN @ ( c_2Enum_2ESUC @ V0h ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) @ V1l ) @ ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ V1l @ V2w ) ) ) ).

thf(thm_2Ewords_2Eword__index__n2w,axiom,
    ! [A_27a: $tType,V0index_20too_20large: $o,V1n: tyop_2Enum_2Enum,V2i: tyop_2Enum_2Enum] :
      ( ( c_2Efcp_2Efcp__index @ $o @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V1n ) @ V2i )
      = ( c_2Ebool_2ECOND @ $o @ ( c_2Eprim__rec_2E_3C @ V2i @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) @ ( c_2Ebit_2EBIT @ V2i @ V1n ) @ ( c_2Ecombin_2EFAIL @ ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > tyop_2Enum_2Enum > $o ) @ $o @ ( c_2Efcp_2Efcp__index @ $o @ A_27a ) @ V0index_20too_20large @ ( c_2Ewords_2En2w @ A_27a @ V1n ) @ V2i ) ) ) ).

thf(thm_2Ewords_2Eword__index,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum,V1i: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V1i @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
     => ( ( c_2Efcp_2Efcp__index @ $o @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) @ V1i )
        = ( c_2Ebit_2EBIT @ V1i @ V0n ) ) ) ).

thf(thm_2Ewords_2Eword__bits__w2w,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1h: tyop_2Enum_2Enum,V2l: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__bits @ A_27b @ V1h @ V2l @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V0w ) )
      = ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ ( c_2Ewords_2Eword__bits @ A_27a @ ( c_2Earithmetic_2EMIN @ V1h @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ V2l @ V0w ) ) ) ).

thf(thm_2Ewords_2Eword__reverse__n2w,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__reverse @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Ebit_2EBIT__REVERSE @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ V0n ) ) ) ).

thf(thm_2Ewords_2Eword__modify__n2w,axiom,
    ! [A_27a: $tType,V0f: tyop_2Enum_2Enum > $o > $o,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__modify @ A_27a @ V0f @ ( c_2Ewords_2En2w @ A_27a @ V1n ) )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Ebit_2EBIT__MODIFY @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ V0f @ V1n ) ) ) ).

thf(thm_2Ewords_2Efcp__n2w,axiom,
    ! [A_27a: $tType,V0f: tyop_2Enum_2Enum > $o] :
      ( ( c_2Efcp_2EFCP @ $o @ A_27a @ V0f )
      = ( c_2Ewords_2Eword__modify @ A_27a
        @ ^ [V1i: tyop_2Enum_2Enum,V2b: $o] : ( V0f @ V1i )
        @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ewords_2Ew2n__w2w,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ew2n @ A_27b @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V0w ) )
      = ( c_2Ebool_2ECOND @ tyop_2Enum_2Enum @ ( c_2Earithmetic_2E_3C_3D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) @ ( c_2Ewords_2Ew2n @ A_27a @ V0w ) @ ( c_2Ewords_2Ew2n @ A_27a @ ( c_2Ewords_2Eword__bits @ A_27a @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ c_2Enum_2E0 @ V0w ) ) ) ) ).

thf(thm_2Ewords_2Ew2n__w2w__le,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] : ( c_2Earithmetic_2E_3C_3D @ ( c_2Ewords_2Ew2n @ A_27b @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V0w ) ) @ ( c_2Ewords_2Ew2n @ A_27a @ V0w ) ) ).

thf(thm_2Ewords_2Ew2w__lt,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] : ( c_2Eprim__rec_2E_3C @ ( c_2Ewords_2Ew2n @ A_27b @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V0w ) ) @ ( c_2Ewords_2Edimword @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ).

thf(thm_2Ewords_2Ew2w__n2w,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ ( c_2Ewords_2En2w @ A_27a @ V0n ) )
      = ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27b ) @ ( c_2Earithmetic_2E_3C_3D @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) @ ( c_2Ewords_2En2w @ A_27b @ V0n ) @ ( c_2Ewords_2En2w @ A_27b @ ( c_2Ebit_2EBITS @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ c_2Enum_2E0 @ V0n ) ) ) ) ).

thf(thm_2Ewords_2Ew2w__0,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ( c_2Ewords_2Ew2w @ A_27b @ A_27a @ ( c_2Ewords_2En2w @ A_27b @ c_2Enum_2E0 ) )
      = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ).

thf(thm_2Ewords_2Ew2n__11__lift,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27b] :
      ( ( ( c_2Earithmetic_2E_3C_3D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Efcp_2Edimindex @ A_27c @ ( c_2Ebool_2Ethe__value @ A_27c ) ) )
        & ( c_2Earithmetic_2E_3C_3D @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ ( c_2Efcp_2Edimindex @ A_27c @ ( c_2Ebool_2Ethe__value @ A_27c ) ) ) )
     => ( ( ( c_2Ewords_2Ew2n @ A_27a @ V0a )
          = ( c_2Ewords_2Ew2n @ A_27b @ V1b ) )
      <=> ( ( c_2Ewords_2Ew2w @ A_27a @ A_27c @ V0a )
          = ( c_2Ewords_2Ew2w @ A_27b @ A_27c @ V1b ) ) ) ) ).

thf(thm_2Ewords_2Eword__extract__n2w,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0n: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2h: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V2h @ V1l @ ( c_2Ewords_2En2w @ A_27a @ V0n ) )
      = ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27b ) @ ( c_2Earithmetic_2E_3C_3D @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) @ ( c_2Ewords_2En2w @ A_27b @ ( c_2Ebit_2EBITS @ ( c_2Earithmetic_2EMIN @ V2h @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ V1l @ V0n ) ) @ ( c_2Ewords_2En2w @ A_27b @ ( c_2Ebit_2EBITS @ ( c_2Earithmetic_2EMIN @ ( c_2Earithmetic_2EMIN @ V2h @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Earithmetic_2E_2B @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V1l ) ) @ V1l @ V0n ) ) ) ) ).

thf(thm_2Ewords_2En2w__BITS,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2n: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V0h @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
     => ( ( c_2Ewords_2En2w @ A_27a @ ( c_2Ebit_2EBITS @ V0h @ V1l @ V2n ) )
        = ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ V1l @ ( c_2Ewords_2En2w @ A_27a @ V2n ) ) ) ) ).

thf(thm_2Ewords_2Eword__extract__w2w,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1h: tyop_2Enum_2Enum,V2l: tyop_2Enum_2Enum] :
      ( ( c_2Earithmetic_2E_3C_3D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) )
     => ( ( c_2Ewords_2Eword__extract @ A_27b @ A_27c @ V1h @ V2l @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V0w ) )
        = ( c_2Ewords_2Eword__extract @ A_27a @ A_27c @ V1h @ V2l @ V0w ) ) ) ).

thf(thm_2Ewords_2EWORD__w2w__EXTRACT,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V0w )
      = ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ c_2Enum_2E0 @ V0w ) ) ).

thf(thm_2Ewords_2EWORD__EQ,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ! [V2x: tyop_2Enum_2Enum] :
          ( ( c_2Eprim__rec_2E_3C @ V2x @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
         => ( ( c_2Ewords_2Eword__bit @ A_27a @ V2x @ V0v )
            = ( c_2Ewords_2Eword__bit @ A_27a @ V2x @ V1w ) ) )
    <=> ( V0v = V1w ) ) ).

thf(thm_2Ewords_2EBIT__UPDATE,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum,V1x: $o] :
      ( ( c_2Efcp_2E_3A_2B @ $o @ A_27a @ V0n @ V1x )
      = ( c_2Ewords_2Eword__modify @ A_27a
        @ ^ [V2i: tyop_2Enum_2Enum,V3b: $o] : ( c_2Ebool_2ECOND @ $o @ ( c_2Emin_2E_3D @ tyop_2Enum_2Enum @ V2i @ V0n ) @ V1x @ V3b ) ) ) ).

thf(thm_2Ewords_2EWORD__MODIFY__BIT,axiom,
    ! [A_27a: $tType,V0f: tyop_2Enum_2Enum > $o > $o,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2i: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V2i @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
     => ( ( c_2Efcp_2Efcp__index @ $o @ A_27a @ ( c_2Ewords_2Eword__modify @ A_27a @ V0f @ V1w ) @ V2i )
        = ( V0f @ V2i @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V1w @ V2i ) ) ) ) ).

thf(thm_2Ewords_2EWORD__BIT__BITS,axiom,
    ! [A_27a: $tType,V0b: tyop_2Enum_2Enum,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__bit @ A_27a @ V0b @ V1w )
    <=> ( ( c_2Ewords_2Eword__bits @ A_27a @ V0b @ V0b @ V1w )
        = ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Ewords_2EWORD__BITS__COMP__THM,axiom,
    ! [A_27a: $tType,V0h1: tyop_2Enum_2Enum,V1l1: tyop_2Enum_2Enum,V2h2: tyop_2Enum_2Enum,V3l2: tyop_2Enum_2Enum,V4w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__bits @ A_27a @ V2h2 @ V3l2 @ ( c_2Ewords_2Eword__bits @ A_27a @ V0h1 @ V1l1 @ V4w ) )
      = ( c_2Ewords_2Eword__bits @ A_27a @ ( c_2Earithmetic_2EMIN @ V0h1 @ ( c_2Earithmetic_2E_2B @ V2h2 @ V1l1 ) ) @ ( c_2Earithmetic_2E_2B @ V3l2 @ V1l1 ) @ V4w ) ) ).

thf(thm_2Ewords_2EWORD__BITS__EXTRACT,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ V1l @ V2w )
      = ( c_2Ewords_2Eword__extract @ A_27a @ A_27a @ V0h @ V1l @ V2w ) ) ).

thf(thm_2Ewords_2EWORD__BITS__LSR,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2w: tyop_2Efcp_2Ecart @ $o @ A_27a,V3n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__lsr @ A_27a @ ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ V1l @ V2w ) @ V3n )
      = ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ ( c_2Earithmetic_2E_2B @ V1l @ V3n ) @ V2w ) ) ).

thf(thm_2Ewords_2EWORD__BITS__ZERO,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Eprim__rec_2E_3C @ V0h @ V1l )
     => ( ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ V1l @ V2w )
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ewords_2EWORD__BITS__ZERO2,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ V1l @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
      = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ).

thf(thm_2Ewords_2EWORD__BITS__ZERO3,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Earithmetic_2E_3C_3D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ V1l )
     => ( ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ V1l @ V2w )
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ewords_2EWORD__BITS__LT,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2w: tyop_2Efcp_2Ecart @ $o @ A_27a] : ( c_2Eprim__rec_2E_3C @ ( c_2Ewords_2Ew2n @ A_27a @ ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ V1l @ V2w ) ) @ ( c_2Earithmetic_2EEXP @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Earithmetic_2E_2D @ ( c_2Enum_2ESUC @ V0h ) @ V1l ) ) ) ).

thf(thm_2Ewords_2EWORD__EXTRACT__LT,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2w: tyop_2Efcp_2Ecart @ $o @ A_27a] : ( c_2Eprim__rec_2E_3C @ ( c_2Ewords_2Ew2n @ A_27b @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V0h @ V1l @ V2w ) ) @ ( c_2Earithmetic_2EEXP @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Earithmetic_2E_2D @ ( c_2Enum_2ESUC @ V0h ) @ V1l ) ) ) ).

thf(thm_2Ewords_2EWORD__EXTRACT__ZERO,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Eprim__rec_2E_3C @ V0h @ V1l )
     => ( ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V0h @ V1l @ V2w )
        = ( c_2Ewords_2En2w @ A_27b @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ewords_2EWORD__EXTRACT__ZERO2,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__extract @ A_27b @ A_27a @ V0h @ V1l @ ( c_2Ewords_2En2w @ A_27b @ c_2Enum_2E0 ) )
      = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ).

thf(thm_2Ewords_2EWORD__EXTRACT__ZERO3,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Earithmetic_2E_3C_3D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ V1l )
     => ( ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V0h @ V1l @ V2w )
        = ( c_2Ewords_2En2w @ A_27b @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ewords_2EWORD__SLICE__THM,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__slice @ A_27a @ V0h @ V1l @ V2w )
      = ( c_2Ewords_2Eword__lsl @ A_27a @ ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ V1l @ V2w ) @ V1l ) ) ).

thf(thm_2Ewords_2EWORD__SLICE__ZERO,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Eprim__rec_2E_3C @ V0h @ V1l )
     => ( ( c_2Ewords_2Eword__slice @ A_27a @ V0h @ V1l @ V2w )
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ewords_2EWORD__SLICE__ZERO2,axiom,
    ! [A_27a: $tType,V0l: tyop_2Enum_2Enum,V1h: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__slice @ A_27a @ V1h @ V0l @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
      = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ).

thf(thm_2Ewords_2EWORD__SLICE__BITS__THM,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__slice @ A_27a @ V0h @ c_2Enum_2E0 @ V1w )
      = ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ c_2Enum_2E0 @ V1w ) ) ).

thf(thm_2Ewords_2EWORD__BITS__SLICE__THM,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ V1l @ ( c_2Ewords_2Eword__slice @ A_27a @ V0h @ V1l @ V2w ) )
      = ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ V1l @ V2w ) ) ).

thf(thm_2Ewords_2EWORD__SLICE__COMP__THM,axiom,
    ! [A_27a: $tType,V0h: tyop_2Enum_2Enum,V1m_27: tyop_2Enum_2Enum,V2m: tyop_2Enum_2Enum,V3l: tyop_2Enum_2Enum,V4w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Earithmetic_2E_3C_3D @ V3l @ V2m )
        & ( V1m_27
          = ( c_2Earithmetic_2E_2B @ V2m @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
        & ( c_2Eprim__rec_2E_3C @ V2m @ V0h ) )
     => ( ( c_2Ewords_2Eword__or @ A_27a @ ( c_2Ewords_2Eword__slice @ A_27a @ V0h @ V1m_27 @ V4w ) @ ( c_2Ewords_2Eword__slice @ A_27a @ V2m @ V3l @ V4w ) )
        = ( c_2Ewords_2Eword__slice @ A_27a @ V0h @ V3l @ V4w ) ) ) ).

thf(thm_2Ewords_2EWORD__EXTRACT__COMP__THM,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27c,V1h: tyop_2Enum_2Enum,V2l: tyop_2Enum_2Enum,V3m: tyop_2Enum_2Enum,V4n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__extract @ A_27b @ A_27a @ V1h @ V2l @ ( c_2Ewords_2Eword__extract @ A_27c @ A_27b @ V3m @ V4n @ V0w ) )
      = ( c_2Ewords_2Eword__extract @ A_27c @ A_27a @ ( c_2Earithmetic_2EMIN @ V3m @ ( c_2Earithmetic_2EMIN @ ( c_2Earithmetic_2E_2B @ V1h @ V4n ) @ ( c_2Earithmetic_2EMIN @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27c @ ( c_2Ebool_2Ethe__value @ A_27c ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2B @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ V4n ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( c_2Earithmetic_2E_2B @ V2l @ V4n ) @ V0w ) ) ).

thf(thm_2Ewords_2EWORD__EXTRACT__BITS__COMP,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0n: tyop_2Efcp_2Ecart @ $o @ A_27a,V1l: tyop_2Enum_2Enum,V2k: tyop_2Enum_2Enum,V3j: tyop_2Enum_2Enum,V4h: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V3j @ V2k @ ( c_2Ewords_2Eword__bits @ A_27a @ V4h @ V1l @ V0n ) )
      = ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ ( c_2Earithmetic_2EMIN @ V4h @ ( c_2Earithmetic_2E_2B @ V3j @ V1l ) ) @ ( c_2Earithmetic_2E_2B @ V2k @ V1l ) @ V0n ) ) ).

thf(thm_2Ewords_2EWORD__ALL__BITS,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1h: tyop_2Enum_2Enum] :
      ( ( c_2Earithmetic_2E_3C_3D @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V1h )
     => ( ( c_2Ewords_2Eword__bits @ A_27a @ V1h @ c_2Enum_2E0 @ V0w )
        = V0w ) ) ).

thf(thm_2Ewords_2EEXTRACT__ALL__BITS,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0h: tyop_2Enum_2Enum,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Earithmetic_2E_3C_3D @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V0h )
     => ( ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V0h @ c_2Enum_2E0 @ V1w )
        = ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V1w ) ) ) ).

thf(thm_2Ewords_2EWORD__BITS__MIN__HIGH,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1h: tyop_2Enum_2Enum,V2l: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V1h )
     => ( ( c_2Ewords_2Eword__bits @ A_27a @ V1h @ V2l @ V0w )
        = ( c_2Ewords_2Eword__bits @ A_27a @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V2l @ V0w ) ) ) ).

thf(thm_2Ewords_2EWORD__EXTRACT__MIN__HIGH,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ! [V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( ( c_2Earithmetic_2E_3C_3D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2E_2B @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ V1l ) )
            & ( c_2Earithmetic_2E_3C_3D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ V0h ) )
         => ( ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V0h @ V1l @ V2w )
            = ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V1l @ V2w ) ) )
      & ! [V3h: tyop_2Enum_2Enum,V4l: tyop_2Enum_2Enum,V5w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( ( c_2Eprim__rec_2E_3C @ ( c_2Earithmetic_2E_2B @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ V4l ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
            & ( c_2Earithmetic_2E_3C_3D @ ( c_2Earithmetic_2E_2B @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ V4l ) @ V3h ) )
         => ( ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V3h @ V4l @ V5w )
            = ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2B @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ V4l ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V4l @ V5w ) ) ) ) ).

thf(thm_2Ewords_2ECONCAT__EXTRACT,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,A_27d: $tType,V0h: tyop_2Enum_2Enum,V1m: tyop_2Enum_2Enum,V2l: tyop_2Enum_2Enum,V3w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( ( c_2Earithmetic_2E_2D @ V0h @ V1m )
          = ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) )
        & ( ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2B @ V1m @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V2l )
          = ( c_2Efcp_2Edimindex @ A_27c @ ( c_2Ebool_2Ethe__value @ A_27c ) ) )
        & ( ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2B @ V0h @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V2l )
          = ( c_2Efcp_2Edimindex @ A_27d @ ( c_2Ebool_2Ethe__value @ A_27d ) ) )
        & ( (~)
          @ ( ( c_2Efcp_2Edimindex @ ( tyop_2Esum_2Esum @ A_27b @ A_27c ) @ ( c_2Ebool_2Ethe__value @ ( tyop_2Esum_2Esum @ A_27b @ A_27c ) ) )
            = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
     => ( ( c_2Ewords_2Eword__concat @ A_27b @ A_27c @ A_27d @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V0h @ ( c_2Earithmetic_2E_2B @ V1m @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V3w ) @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27c @ V1m @ V2l @ V3w ) )
        = ( c_2Ewords_2Eword__extract @ A_27a @ A_27d @ V0h @ V2l @ V3w ) ) ) ).

thf(thm_2Ewords_2EEXTRACT__CONCAT,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27b] :
      ( ( ( c_2Epred__set_2EFINITE @ A_27a @ ( c_2Epred__set_2EUNIV @ A_27a ) )
        & ( c_2Epred__set_2EFINITE @ A_27b @ ( c_2Epred__set_2EUNIV @ A_27b ) )
        & ( c_2Earithmetic_2E_3C_3D @ ( c_2Earithmetic_2E_2B @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) @ ( c_2Efcp_2Edimindex @ A_27c @ ( c_2Ebool_2Ethe__value @ A_27c ) ) ) )
     => ( ( ( c_2Ewords_2Eword__extract @ A_27c @ A_27b @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ c_2Enum_2E0 @ ( c_2Ewords_2Eword__concat @ A_27a @ A_27b @ A_27c @ V0v @ V1w ) )
          = V1w )
        & ( ( c_2Ewords_2Eword__extract @ A_27c @ A_27a @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2B @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ ( c_2Ewords_2Eword__concat @ A_27a @ A_27b @ A_27c @ V0v @ V1w ) )
          = V0v ) ) ) ).

thf(thm_2Ewords_2EEXTRACT__JOIN,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0h: tyop_2Enum_2Enum,V1m: tyop_2Enum_2Enum,V2m_27: tyop_2Enum_2Enum,V3l: tyop_2Enum_2Enum,V4s: tyop_2Enum_2Enum,V5w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Earithmetic_2E_3C_3D @ V3l @ V1m )
        & ( c_2Earithmetic_2E_3C_3D @ V2m_27 @ V0h )
        & ( V2m_27
          = ( c_2Earithmetic_2E_2B @ V1m @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
        & ( V4s
          = ( c_2Earithmetic_2E_2D @ V2m_27 @ V3l ) ) )
     => ( ( c_2Ewords_2Eword__or @ A_27b @ ( c_2Ewords_2Eword__lsl @ A_27b @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V0h @ V2m_27 @ V5w ) @ V4s ) @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V1m @ V3l @ V5w ) )
        = ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ ( c_2Earithmetic_2EMIN @ V0h @ ( c_2Earithmetic_2EMIN @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2B @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ V3l ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ V3l @ V5w ) ) ) ).

thf(thm_2Ewords_2EEXTRACT__JOIN__ADD,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0h: tyop_2Enum_2Enum,V1m: tyop_2Enum_2Enum,V2m_27: tyop_2Enum_2Enum,V3l: tyop_2Enum_2Enum,V4s: tyop_2Enum_2Enum,V5w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Earithmetic_2E_3C_3D @ V3l @ V1m )
        & ( c_2Earithmetic_2E_3C_3D @ V2m_27 @ V0h )
        & ( V2m_27
          = ( c_2Earithmetic_2E_2B @ V1m @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
        & ( V4s
          = ( c_2Earithmetic_2E_2D @ V2m_27 @ V3l ) ) )
     => ( ( c_2Ewords_2Eword__add @ A_27b @ ( c_2Ewords_2Eword__lsl @ A_27b @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V0h @ V2m_27 @ V5w ) @ V4s ) @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V1m @ V3l @ V5w ) )
        = ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ ( c_2Earithmetic_2EMIN @ V0h @ ( c_2Earithmetic_2EMIN @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2B @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ V3l ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ V3l @ V5w ) ) ) ).

thf(thm_2Ewords_2EEXTEND__EXTRACT,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Efcp_2Edimindex @ A_27c @ ( c_2Ebool_2Ethe__value @ A_27c ) )
        = ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2B @ V0h @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V1l ) )
     => ( ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V0h @ V1l @ V2w )
        = ( c_2Ewords_2Ew2w @ A_27c @ A_27b @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27c @ V0h @ V1l @ V2w ) ) ) ) ).

thf(thm_2Ewords_2EWORD__SLICE__OVER__BITWISE,axiom,
    ! [A_27a: $tType] :
      ( ! [V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2v: tyop_2Efcp_2Ecart @ $o @ A_27a,V3w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__and @ A_27a @ ( c_2Ewords_2Eword__slice @ A_27a @ V0h @ V1l @ V2v ) @ ( c_2Ewords_2Eword__slice @ A_27a @ V0h @ V1l @ V3w ) )
          = ( c_2Ewords_2Eword__slice @ A_27a @ V0h @ V1l @ ( c_2Ewords_2Eword__and @ A_27a @ V2v @ V3w ) ) )
      & ! [V4h: tyop_2Enum_2Enum,V5l: tyop_2Enum_2Enum,V6v: tyop_2Efcp_2Ecart @ $o @ A_27a,V7w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__or @ A_27a @ ( c_2Ewords_2Eword__slice @ A_27a @ V4h @ V5l @ V6v ) @ ( c_2Ewords_2Eword__slice @ A_27a @ V4h @ V5l @ V7w ) )
          = ( c_2Ewords_2Eword__slice @ A_27a @ V4h @ V5l @ ( c_2Ewords_2Eword__or @ A_27a @ V6v @ V7w ) ) )
      & ! [V8h: tyop_2Enum_2Enum,V9l: tyop_2Enum_2Enum,V10v: tyop_2Efcp_2Ecart @ $o @ A_27a,V11w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__xor @ A_27a @ ( c_2Ewords_2Eword__slice @ A_27a @ V8h @ V9l @ V10v ) @ ( c_2Ewords_2Eword__slice @ A_27a @ V8h @ V9l @ V11w ) )
          = ( c_2Ewords_2Eword__slice @ A_27a @ V8h @ V9l @ ( c_2Ewords_2Eword__xor @ A_27a @ V10v @ V11w ) ) ) ) ).

thf(thm_2Ewords_2EWORD__BITS__OVER__BITWISE,axiom,
    ! [A_27a: $tType] :
      ( ! [V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2v: tyop_2Efcp_2Ecart @ $o @ A_27a,V3w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__and @ A_27a @ ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ V1l @ V2v ) @ ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ V1l @ V3w ) )
          = ( c_2Ewords_2Eword__bits @ A_27a @ V0h @ V1l @ ( c_2Ewords_2Eword__and @ A_27a @ V2v @ V3w ) ) )
      & ! [V4h: tyop_2Enum_2Enum,V5l: tyop_2Enum_2Enum,V6v: tyop_2Efcp_2Ecart @ $o @ A_27a,V7w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__or @ A_27a @ ( c_2Ewords_2Eword__bits @ A_27a @ V4h @ V5l @ V6v ) @ ( c_2Ewords_2Eword__bits @ A_27a @ V4h @ V5l @ V7w ) )
          = ( c_2Ewords_2Eword__bits @ A_27a @ V4h @ V5l @ ( c_2Ewords_2Eword__or @ A_27a @ V6v @ V7w ) ) )
      & ! [V8h: tyop_2Enum_2Enum,V9l: tyop_2Enum_2Enum,V10v: tyop_2Efcp_2Ecart @ $o @ A_27a,V11w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__xor @ A_27a @ ( c_2Ewords_2Eword__bits @ A_27a @ V8h @ V9l @ V10v ) @ ( c_2Ewords_2Eword__bits @ A_27a @ V8h @ V9l @ V11w ) )
          = ( c_2Ewords_2Eword__bits @ A_27a @ V8h @ V9l @ ( c_2Ewords_2Eword__xor @ A_27a @ V10v @ V11w ) ) ) ) ).

thf(thm_2Ewords_2EWORD__w2w__OVER__BITWISE,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ! [V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__and @ A_27b @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V0v ) @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V1w ) )
          = ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ ( c_2Ewords_2Eword__and @ A_27a @ V0v @ V1w ) ) )
      & ! [V2v: tyop_2Efcp_2Ecart @ $o @ A_27a,V3w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__or @ A_27b @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V2v ) @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V3w ) )
          = ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ ( c_2Ewords_2Eword__or @ A_27a @ V2v @ V3w ) ) )
      & ! [V4v: tyop_2Efcp_2Ecart @ $o @ A_27a,V5w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__xor @ A_27b @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V4v ) @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V5w ) )
          = ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ ( c_2Ewords_2Eword__xor @ A_27a @ V4v @ V5w ) ) ) ) ).

thf(thm_2Ewords_2EWORD__EXTRACT__OVER__BITWISE,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,A_27d: $tType] :
      ( ! [V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2v: tyop_2Efcp_2Ecart @ $o @ A_27a,V3w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__and @ A_27b @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V0h @ V1l @ V2v ) @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V0h @ V1l @ V3w ) )
          = ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V0h @ V1l @ ( c_2Ewords_2Eword__and @ A_27a @ V2v @ V3w ) ) )
      & ! [V4h: tyop_2Enum_2Enum,V5l: tyop_2Enum_2Enum,V6v: tyop_2Efcp_2Ecart @ $o @ A_27a,V7w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__or @ A_27c @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27c @ V4h @ V5l @ V6v ) @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27c @ V4h @ V5l @ V7w ) )
          = ( c_2Ewords_2Eword__extract @ A_27a @ A_27c @ V4h @ V5l @ ( c_2Ewords_2Eword__or @ A_27a @ V6v @ V7w ) ) )
      & ! [V8h: tyop_2Enum_2Enum,V9l: tyop_2Enum_2Enum,V10v: tyop_2Efcp_2Ecart @ $o @ A_27a,V11w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__xor @ A_27d @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27d @ V8h @ V9l @ V10v ) @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27d @ V8h @ V9l @ V11w ) )
          = ( c_2Ewords_2Eword__extract @ A_27a @ A_27d @ V8h @ V9l @ ( c_2Ewords_2Eword__xor @ A_27a @ V10v @ V11w ) ) ) ) ).

thf(thm_2Ewords_2EWORD__w2w__OVER__ADD,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ ( c_2Ewords_2Eword__add @ A_27a @ V0a @ V1b ) )
      = ( c_2Ewords_2Eword__bits @ A_27b @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ c_2Enum_2E0 @ ( c_2Ewords_2Eword__add @ A_27b @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V0a ) @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V1b ) ) ) ) ).

thf(thm_2Ewords_2EWORD__w2w__OVER__MUL,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ ( c_2Ewords_2Eword__mul @ A_27a @ V0a @ V1b ) )
      = ( c_2Ewords_2Eword__bits @ A_27b @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ c_2Enum_2E0 @ ( c_2Ewords_2Eword__mul @ A_27b @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V0a ) @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V1b ) ) ) ) ).

thf(thm_2Ewords_2EWORD__EXTRACT__OVER__ADD,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a,V2h: tyop_2Enum_2Enum] :
      ( ( ( c_2Earithmetic_2E_3C_3D @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V2h )
        & ( c_2Earithmetic_2E_3C_3D @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) )
     => ( ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V2h @ c_2Enum_2E0 @ ( c_2Ewords_2Eword__add @ A_27a @ V0a @ V1b ) )
        = ( c_2Ewords_2Eword__add @ A_27b @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V2h @ c_2Enum_2E0 @ V0a ) @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V2h @ c_2Enum_2E0 @ V1b ) ) ) ) ).

thf(thm_2Ewords_2EWORD__EXTRACT__OVER__MUL,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a,V2h: tyop_2Enum_2Enum] :
      ( ( ( c_2Earithmetic_2E_3C_3D @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V2h )
        & ( c_2Earithmetic_2E_3C_3D @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) )
     => ( ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V2h @ c_2Enum_2E0 @ ( c_2Ewords_2Eword__mul @ A_27a @ V0a @ V1b ) )
        = ( c_2Ewords_2Eword__mul @ A_27b @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V2h @ c_2Enum_2E0 @ V0a ) @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V2h @ c_2Enum_2E0 @ V1b ) ) ) ) ).

thf(thm_2Ewords_2EWORD__EXTRACT__OVER__ADD2,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a,V2h: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V2h @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
     => ( ( c_2Ewords_2Eword__extract @ A_27b @ A_27b @ V2h @ c_2Enum_2E0 @ ( c_2Ewords_2Eword__add @ A_27b @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V2h @ c_2Enum_2E0 @ V0a ) @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V2h @ c_2Enum_2E0 @ V1b ) ) )
        = ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V2h @ c_2Enum_2E0 @ ( c_2Ewords_2Eword__add @ A_27a @ V0a @ V1b ) ) ) ) ).

thf(thm_2Ewords_2EWORD__EXTRACT__OVER__MUL2,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a,V2h: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V2h @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
     => ( ( c_2Ewords_2Eword__extract @ A_27b @ A_27b @ V2h @ c_2Enum_2E0 @ ( c_2Ewords_2Eword__mul @ A_27b @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V2h @ c_2Enum_2E0 @ V0a ) @ ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V2h @ c_2Enum_2E0 @ V1b ) ) )
        = ( c_2Ewords_2Eword__extract @ A_27a @ A_27b @ V2h @ c_2Enum_2E0 @ ( c_2Ewords_2Eword__mul @ A_27a @ V0a @ V1b ) ) ) ) ).

thf(thm_2Ewords_2EWORD__EXTRACT__ID,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1h: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ ( c_2Ewords_2Ew2n @ A_27a @ V0w ) @ ( c_2Earithmetic_2EEXP @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Enum_2ESUC @ V1h ) ) )
     => ( ( c_2Ewords_2Eword__extract @ A_27a @ A_27a @ V1h @ c_2Enum_2E0 @ V0w )
        = V0w ) ) ).

thf(thm_2Ewords_2EBIT__SET,axiom,
    ! [V0i: tyop_2Enum_2Enum,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Ebit_2EBIT @ V0i @ V1n )
      = ( c_2Ebool_2EIN @ tyop_2Enum_2Enum @ V0i @ ( c_2Ewords_2EBIT__SET @ c_2Enum_2E0 @ V1n ) ) ) ).

thf(thm_2Ewords_2EWORD__LITERAL__AND,axiom,
    ! [A_27a: $tType] :
      ( ! [V0n: tyop_2Enum_2Enum,V1m: tyop_2Enum_2Enum] :
          ( ( c_2Ewords_2Eword__and @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) @ ( c_2Ewords_2En2w @ A_27a @ V1m ) )
          = ( c_2Ewords_2En2w @ A_27a @ ( c_2Ebit_2EBITWISE @ ( c_2Enum_2ESUC @ ( c_2Earithmetic_2EMIN @ ( c_2Ebit_2ELOG2 @ V0n ) @ ( c_2Ebit_2ELOG2 @ V1m ) ) ) @ c_2Ebool_2E_2F_5C @ V0n @ V1m ) ) )
      & ! [V2n: tyop_2Enum_2Enum,V3m: tyop_2Enum_2Enum] :
          ( ( c_2Ewords_2Eword__and @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V2n ) @ ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V3m ) ) )
          = ( c_2Ewords_2En2w @ A_27a
            @ ( c_2Ebit_2EBITWISE @ ( c_2Enum_2ESUC @ ( c_2Ebit_2ELOG2 @ V2n ) )
              @ ^ [V4a: $o,V5b: $o] : ( c_2Ebool_2E_2F_5C @ V4a @ ( c_2Ebool_2E_7E @ V5b ) )
              @ V2n
              @ V3m ) ) )
      & ! [V6n: tyop_2Enum_2Enum,V7m: tyop_2Enum_2Enum] :
          ( ( c_2Ewords_2Eword__and @ A_27a @ ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V7m ) ) @ ( c_2Ewords_2En2w @ A_27a @ V6n ) )
          = ( c_2Ewords_2En2w @ A_27a
            @ ( c_2Ebit_2EBITWISE @ ( c_2Enum_2ESUC @ ( c_2Ebit_2ELOG2 @ V6n ) )
              @ ^ [V8a: $o,V9b: $o] : ( c_2Ebool_2E_2F_5C @ V8a @ ( c_2Ebool_2E_7E @ V9b ) )
              @ V6n
              @ V7m ) ) )
      & ! [V10n: tyop_2Enum_2Enum,V11m: tyop_2Enum_2Enum] :
          ( ( c_2Ewords_2Eword__and @ A_27a @ ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V10n ) ) @ ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V11m ) ) )
          = ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Ebit_2EBITWISE @ ( c_2Enum_2ESUC @ ( c_2Earithmetic_2EMAX @ ( c_2Ebit_2ELOG2 @ V10n ) @ ( c_2Ebit_2ELOG2 @ V11m ) ) ) @ c_2Ebool_2E_5C_2F @ V10n @ V11m ) ) ) ) ) ).

thf(thm_2Ewords_2EWORD__LITERAL__OR,axiom,
    ! [A_27a: $tType] :
      ( ! [V0n: tyop_2Enum_2Enum,V1m: tyop_2Enum_2Enum] :
          ( ( c_2Ewords_2Eword__or @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) @ ( c_2Ewords_2En2w @ A_27a @ V1m ) )
          = ( c_2Ewords_2En2w @ A_27a @ ( c_2Ebit_2EBITWISE @ ( c_2Enum_2ESUC @ ( c_2Earithmetic_2EMAX @ ( c_2Ebit_2ELOG2 @ V0n ) @ ( c_2Ebit_2ELOG2 @ V1m ) ) ) @ c_2Ebool_2E_5C_2F @ V0n @ V1m ) ) )
      & ! [V2n: tyop_2Enum_2Enum,V3m: tyop_2Enum_2Enum] :
          ( ( c_2Ewords_2Eword__or @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V2n ) @ ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V3m ) ) )
          = ( c_2Ewords_2Eword__1comp @ A_27a
            @ ( c_2Ewords_2En2w @ A_27a
              @ ( c_2Ebit_2EBITWISE @ ( c_2Enum_2ESUC @ ( c_2Ebit_2ELOG2 @ V3m ) )
                @ ^ [V4a: $o,V5b: $o] : ( c_2Ebool_2E_2F_5C @ V4a @ ( c_2Ebool_2E_7E @ V5b ) )
                @ V3m
                @ V2n ) ) ) )
      & ! [V6n: tyop_2Enum_2Enum,V7m: tyop_2Enum_2Enum] :
          ( ( c_2Ewords_2Eword__or @ A_27a @ ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V7m ) ) @ ( c_2Ewords_2En2w @ A_27a @ V6n ) )
          = ( c_2Ewords_2Eword__1comp @ A_27a
            @ ( c_2Ewords_2En2w @ A_27a
              @ ( c_2Ebit_2EBITWISE @ ( c_2Enum_2ESUC @ ( c_2Ebit_2ELOG2 @ V7m ) )
                @ ^ [V8a: $o,V9b: $o] : ( c_2Ebool_2E_2F_5C @ V8a @ ( c_2Ebool_2E_7E @ V9b ) )
                @ V7m
                @ V6n ) ) ) )
      & ! [V10n: tyop_2Enum_2Enum,V11m: tyop_2Enum_2Enum] :
          ( ( c_2Ewords_2Eword__or @ A_27a @ ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V10n ) ) @ ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V11m ) ) )
          = ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Ebit_2EBITWISE @ ( c_2Enum_2ESUC @ ( c_2Earithmetic_2EMIN @ ( c_2Ebit_2ELOG2 @ V10n ) @ ( c_2Ebit_2ELOG2 @ V11m ) ) ) @ c_2Ebool_2E_2F_5C @ V10n @ V11m ) ) ) ) ) ).

thf(thm_2Ewords_2EWORD__LITERAL__XOR,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum,V1m: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__xor @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) @ ( c_2Ewords_2En2w @ A_27a @ V1m ) )
      = ( c_2Ewords_2En2w @ A_27a
        @ ( c_2Ebit_2EBITWISE @ ( c_2Enum_2ESUC @ ( c_2Earithmetic_2EMAX @ ( c_2Ebit_2ELOG2 @ V0n ) @ ( c_2Ebit_2ELOG2 @ V1m ) ) )
          @ ^ [V2x: $o,V3y: $o] : ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ $o @ V2x @ V3y ) )
          @ V0n
          @ V1m ) ) ) ).

thf(thm_2Ewords_2Eword__replicate__concat__word__list,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0n: tyop_2Enum_2Enum,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__replicate @ A_27a @ A_27b @ V0n @ V1w )
      = ( c_2Ewords_2Econcat__word__list @ A_27a @ A_27b @ ( c_2Elist_2EGENLIST @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ tyop_2Enum_2Enum @ V1w ) @ V0n ) ) ) ).

thf(thm_2Ewords_2Ebit__field__insert,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0h: tyop_2Enum_2Enum,V1l: tyop_2Enum_2Enum,V2a: tyop_2Efcp_2Ecart @ $o @ A_27a,V3b: tyop_2Efcp_2Ecart @ $o @ A_27b] :
      ( ( c_2Eprim__rec_2E_3C @ V0h @ ( c_2Earithmetic_2E_2B @ V1l @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) )
     => ( ( c_2Ewords_2Ebit__field__insert @ A_27b @ A_27a @ V0h @ V1l @ V2a @ V3b )
        = ( c_2Ebool_2ELET @ ( tyop_2Efcp_2Ecart @ $o @ A_27b ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27b )
          @ ^ [V4mask: tyop_2Efcp_2Ecart @ $o @ A_27b] : ( c_2Ewords_2Eword__or @ A_27b @ ( c_2Ewords_2Eword__and @ A_27b @ ( c_2Ewords_2Eword__lsl @ A_27b @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V2a ) @ V1l ) @ V4mask ) @ ( c_2Ewords_2Eword__and @ A_27b @ V3b @ ( c_2Ewords_2Eword__1comp @ A_27b @ V4mask ) ) )
          @ ( c_2Ewords_2Eword__slice @ A_27b @ V0h @ V1l @ ( c_2Ewords_2Eword__2comp @ A_27b @ ( c_2Ewords_2En2w @ A_27b @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ) ).

thf(thm_2Ewords_2Eword__join__index,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0i: tyop_2Enum_2Enum,V1a: tyop_2Efcp_2Ecart @ $o @ A_27a,V2b: tyop_2Efcp_2Ecart @ $o @ A_27b] :
      ( ( ( c_2Epred__set_2EFINITE @ A_27a @ ( c_2Epred__set_2EUNIV @ A_27a ) )
        & ( c_2Epred__set_2EFINITE @ A_27b @ ( c_2Epred__set_2EUNIV @ A_27b ) )
        & ( c_2Eprim__rec_2E_3C @ V0i @ ( c_2Efcp_2Edimindex @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) @ ( c_2Ebool_2Ethe__value @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) ) ) ) )
     => ( ( c_2Efcp_2Efcp__index @ $o @ ( tyop_2Esum_2Esum @ A_27a @ A_27b ) @ ( c_2Ewords_2Eword__join @ A_27a @ A_27b @ V1a @ V2b ) @ V0i )
        = ( c_2Ebool_2ECOND @ $o @ ( c_2Eprim__rec_2E_3C @ V0i @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27b @ V2b @ V0i ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V1a @ ( c_2Earithmetic_2E_2D @ V0i @ ( c_2Efcp_2Edimindex @ A_27b @ ( c_2Ebool_2Ethe__value @ A_27b ) ) ) ) ) ) ) ).

thf(thm_2Ewords_2Efoldl__reduce__and,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ereduce__and @ A_27a @ V0w )
      = ( c_2Ebool_2ELET @ ( tyop_2Elist_2Elist @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
        @ ^ [V1l: tyop_2Elist_2Elist @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )] : ( c_2Elist_2EFOLDL @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ewords_2Eword__and @ tyop_2Eone_2Eone ) @ ( c_2Elist_2EHD @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V1l ) @ ( c_2Elist_2ETL @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V1l ) )
        @ ( c_2Elist_2EGENLIST @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
          @ ^ [V2i: tyop_2Enum_2Enum] :
              ( c_2Ebool_2ELET @ tyop_2Enum_2Enum @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
              @ ^ [V3n: tyop_2Enum_2Enum] : ( c_2Ewords_2Eword__extract @ A_27a @ tyop_2Eone_2Eone @ V3n @ V3n @ V0w )
              @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V2i ) )
          @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ).

thf(thm_2Ewords_2Efoldl__reduce__or,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ereduce__or @ A_27a @ V0w )
      = ( c_2Ebool_2ELET @ ( tyop_2Elist_2Elist @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
        @ ^ [V1l: tyop_2Elist_2Elist @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )] : ( c_2Elist_2EFOLDL @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ewords_2Eword__or @ tyop_2Eone_2Eone ) @ ( c_2Elist_2EHD @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V1l ) @ ( c_2Elist_2ETL @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V1l ) )
        @ ( c_2Elist_2EGENLIST @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
          @ ^ [V2i: tyop_2Enum_2Enum] :
              ( c_2Ebool_2ELET @ tyop_2Enum_2Enum @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
              @ ^ [V3n: tyop_2Enum_2Enum] : ( c_2Ewords_2Eword__extract @ A_27a @ tyop_2Eone_2Eone @ V3n @ V3n @ V0w )
              @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V2i ) )
          @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ).

thf(thm_2Ewords_2Efoldl__reduce__xor,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ereduce__xor @ A_27a @ V0w )
      = ( c_2Ebool_2ELET @ ( tyop_2Elist_2Elist @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
        @ ^ [V1l: tyop_2Elist_2Elist @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )] : ( c_2Elist_2EFOLDL @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ewords_2Eword__xor @ tyop_2Eone_2Eone ) @ ( c_2Elist_2EHD @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V1l ) @ ( c_2Elist_2ETL @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V1l ) )
        @ ( c_2Elist_2EGENLIST @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
          @ ^ [V2i: tyop_2Enum_2Enum] :
              ( c_2Ebool_2ELET @ tyop_2Enum_2Enum @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
              @ ^ [V3n: tyop_2Enum_2Enum] : ( c_2Ewords_2Eword__extract @ A_27a @ tyop_2Eone_2Eone @ V3n @ V3n @ V0w )
              @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V2i ) )
          @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ).

thf(thm_2Ewords_2Efoldl__reduce__nand,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ereduce__nand @ A_27a @ V0w )
      = ( c_2Ebool_2ELET @ ( tyop_2Elist_2Elist @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
        @ ^ [V1l: tyop_2Elist_2Elist @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )] : ( c_2Elist_2EFOLDL @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ewords_2Eword__nand @ tyop_2Eone_2Eone ) @ ( c_2Elist_2EHD @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V1l ) @ ( c_2Elist_2ETL @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V1l ) )
        @ ( c_2Elist_2EGENLIST @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
          @ ^ [V2i: tyop_2Enum_2Enum] :
              ( c_2Ebool_2ELET @ tyop_2Enum_2Enum @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
              @ ^ [V3n: tyop_2Enum_2Enum] : ( c_2Ewords_2Eword__extract @ A_27a @ tyop_2Eone_2Eone @ V3n @ V3n @ V0w )
              @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V2i ) )
          @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ).

thf(thm_2Ewords_2Efoldl__reduce__nor,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ereduce__nor @ A_27a @ V0w )
      = ( c_2Ebool_2ELET @ ( tyop_2Elist_2Elist @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
        @ ^ [V1l: tyop_2Elist_2Elist @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )] : ( c_2Elist_2EFOLDL @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ewords_2Eword__nor @ tyop_2Eone_2Eone ) @ ( c_2Elist_2EHD @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V1l ) @ ( c_2Elist_2ETL @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V1l ) )
        @ ( c_2Elist_2EGENLIST @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
          @ ^ [V2i: tyop_2Enum_2Enum] :
              ( c_2Ebool_2ELET @ tyop_2Enum_2Enum @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
              @ ^ [V3n: tyop_2Enum_2Enum] : ( c_2Ewords_2Eword__extract @ A_27a @ tyop_2Eone_2Eone @ V3n @ V3n @ V0w )
              @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V2i ) )
          @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ).

thf(thm_2Ewords_2Efoldl__reduce__xnor,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ereduce__xnor @ A_27a @ V0w )
      = ( c_2Ebool_2ELET @ ( tyop_2Elist_2Elist @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
        @ ^ [V1l: tyop_2Elist_2Elist @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )] : ( c_2Elist_2EFOLDL @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ewords_2Eword__xnor @ tyop_2Eone_2Eone ) @ ( c_2Elist_2EHD @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V1l ) @ ( c_2Elist_2ETL @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V1l ) )
        @ ( c_2Elist_2EGENLIST @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
          @ ^ [V2i: tyop_2Enum_2Enum] :
              ( c_2Ebool_2ELET @ tyop_2Enum_2Enum @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
              @ ^ [V3n: tyop_2Enum_2Enum] : ( c_2Ewords_2Eword__extract @ A_27a @ tyop_2Eone_2Eone @ V3n @ V3n @ V0w )
              @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V2i ) )
          @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ) ).

thf(thm_2Ewords_2ELOG2__w2n__lt,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( (~)
        @ ( V0w
          = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) )
     => ( c_2Eprim__rec_2E_3C @ ( c_2Ebit_2ELOG2 @ ( c_2Ewords_2Ew2n @ A_27a @ V0w ) ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ).

thf(thm_2Ewords_2ELOG2__w2n,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( (~)
        @ ( V0w
          = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) )
     => ( ( c_2Ebit_2ELOG2 @ ( c_2Ewords_2Ew2n @ A_27a @ V0w ) )
        = ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) )
          @ ( c_2Ewhile_2ELEAST
            @ ^ [V1i: tyop_2Enum_2Enum] : ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0w @ ( c_2Earithmetic_2E_2D @ ( c_2Earithmetic_2E_2D @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V1i ) ) ) ) ) ) ).

thf(thm_2Ewords_2ELEAST__BIT__LT,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( (~)
        @ ( V0w
          = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) )
     => ( c_2Eprim__rec_2E_3C
        @ ( c_2Ewhile_2ELEAST
          @ ^ [V1i: tyop_2Enum_2Enum] : ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0w @ V1i ) )
        @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) ) ).

thf(thm_2Ewords_2Eword__reduce__n2w,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum,V1f: $o > $o > $o] :
      ( ( c_2Ewords_2Eword__reduce @ A_27a @ V1f @ ( c_2Ewords_2En2w @ A_27a @ V0n ) )
      = ( c_2Efcp_2EFCP @ $o @ tyop_2Eone_2Eone
        @ ( c_2Ecombin_2EK @ $o @ tyop_2Enum_2Enum
          @ ( c_2Ebool_2ELET @ ( tyop_2Elist_2Elist @ $o ) @ $o
            @ ^ [V2l: tyop_2Elist_2Elist @ $o] : ( c_2Elist_2EFOLDL @ $o @ $o @ V1f @ ( c_2Elist_2EHD @ $o @ V2l ) @ ( c_2Elist_2ETL @ $o @ V2l ) )
            @ ( c_2Enumposrep_2EBOOLIFY @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) @ V0n @ ( c_2Elist_2ENIL @ $o ) ) ) ) ) ) ).

thf(thm_2Ewords_2ENOT__UINTMAXw,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( (~)
        @ ( V0w
          = ( c_2Ewords_2Eword__T @ A_27a ) ) )
     => ? [V1i: tyop_2Enum_2Enum] :
          ( ( c_2Eprim__rec_2E_3C @ V1i @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
          & ( (~) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0w @ V1i ) ) ) ) ).

thf(thm_2Ewords_2ENOT__0w,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( (~)
        @ ( V0w
          = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) )
     => ? [V1i: tyop_2Enum_2Enum] :
          ( ( c_2Eprim__rec_2E_3C @ V1i @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
          & ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0w @ V1i ) ) ) ).

thf(thm_2Ewords_2Ereduce__and,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ereduce__and @ A_27a @ V0w )
      = ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ V0w @ ( c_2Ewords_2Eword__T @ A_27a ) ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ewords_2Ereduce__or,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Ereduce__or @ A_27a @ V0w )
      = ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ A_27a ) @ V0w @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ c_2Enum_2E0 ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Ewords_2EWORD__ADD__0,axiom,
    ! [A_27a: $tType] :
      ( ! [V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__add @ A_27a @ V0w @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
          = V0w )
      & ! [V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) @ V1w )
          = V1w ) ) ).

thf(thm_2Ewords_2EWORD__ADD__ASSOC,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__add @ A_27a @ V0v @ ( c_2Ewords_2Eword__add @ A_27a @ V1w @ V2x ) )
      = ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V1w ) @ V2x ) ) ).

thf(thm_2Ewords_2EWORD__MULT__ASSOC,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ ( c_2Ewords_2Eword__mul @ A_27a @ V1w @ V2x ) )
      = ( c_2Ewords_2Eword__mul @ A_27a @ ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ V1w ) @ V2x ) ) ).

thf(thm_2Ewords_2EWORD__ADD__COMM,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V1w )
      = ( c_2Ewords_2Eword__add @ A_27a @ V1w @ V0v ) ) ).

thf(thm_2Ewords_2EWORD__MULT__COMM,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ V1w )
      = ( c_2Ewords_2Eword__mul @ A_27a @ V1w @ V0v ) ) ).

thf(thm_2Ewords_2EWORD__MULT__CLAUSES,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__mul @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) @ V0v )
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
      & ( ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
      & ( ( c_2Ewords_2Eword__mul @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V0v )
        = V0v )
      & ( ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
        = V0v )
      & ( ( c_2Ewords_2Eword__mul @ A_27a @ ( c_2Ewords_2Eword__add @ A_27a @ V0v @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ V1w )
        = ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ V1w ) @ V1w ) )
      & ( ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ ( c_2Ewords_2Eword__add @ A_27a @ V1w @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
        = ( c_2Ewords_2Eword__add @ A_27a @ V0v @ ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ V1w ) ) ) ) ).

thf(thm_2Ewords_2EWORD__LEFT__ADD__DISTRIB,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ ( c_2Ewords_2Eword__add @ A_27a @ V1w @ V2x ) )
      = ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ V1w ) @ ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ V2x ) ) ) ).

thf(thm_2Ewords_2EWORD__RIGHT__ADD__DISTRIB,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__mul @ A_27a @ ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V1w ) @ V2x )
      = ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ V2x ) @ ( c_2Ewords_2Eword__mul @ A_27a @ V1w @ V2x ) ) ) ).

thf(thm_2Ewords_2EWORD__ADD__SUB__ASSOC,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__sub @ A_27a @ ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V1w ) @ V2x )
      = ( c_2Ewords_2Eword__add @ A_27a @ V0v @ ( c_2Ewords_2Eword__sub @ A_27a @ V1w @ V2x ) ) ) ).

thf(thm_2Ewords_2EWORD__ADD__SUB__SYM,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__sub @ A_27a @ ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V1w ) @ V2x )
      = ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2Eword__sub @ A_27a @ V0v @ V2x ) @ V1w ) ) ).

thf(thm_2Ewords_2EWORD__ADD__LINV,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V0w ) @ V0w )
      = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ).

thf(thm_2Ewords_2EWORD__ADD__RINV,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__add @ A_27a @ V0w @ ( c_2Ewords_2Eword__2comp @ A_27a @ V0w ) )
      = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ).

thf(thm_2Ewords_2EWORD__SUB__REFL,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__sub @ A_27a @ V0w @ V0w )
      = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ).

thf(thm_2Ewords_2EWORD__SUB__ADD2,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__add @ A_27a @ V0v @ ( c_2Ewords_2Eword__sub @ A_27a @ V1w @ V0v ) )
      = V1w ) ).

thf(thm_2Ewords_2EWORD__ADD__SUB,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__sub @ A_27a @ ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V1w ) @ V1w )
      = V0v ) ).

thf(thm_2Ewords_2EWORD__SUB__ADD,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2Eword__sub @ A_27a @ V0v @ V1w ) @ V1w )
      = V0v ) ).

thf(thm_2Ewords_2EWORD__ADD__EQ__SUB,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V1w )
        = V2x )
    <=> ( V0v
        = ( c_2Ewords_2Eword__sub @ A_27a @ V2x @ V1w ) ) ) ).

thf(thm_2Ewords_2EWORD__ADD__INV__0__EQ,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V1w )
        = V0v )
    <=> ( V1w
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ewords_2EWORD__EQ__ADD__LCANCEL,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V1w )
        = ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V2x ) )
    <=> ( V1w = V2x ) ) ).

thf(thm_2Ewords_2EWORD__EQ__ADD__RCANCEL,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V1w )
        = ( c_2Ewords_2Eword__add @ A_27a @ V2x @ V1w ) )
    <=> ( V0v = V2x ) ) ).

thf(thm_2Ewords_2EWORD__NEG,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__2comp @ A_27a @ V0w )
      = ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2Eword__1comp @ A_27a @ V0w ) @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Ewords_2EWORD__NOT,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__1comp @ A_27a @ V0w )
      = ( c_2Ewords_2Eword__sub @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V0w ) @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Ewords_2EWORD__NEG__0,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
      = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ).

thf(thm_2Ewords_2EWORD__NEG__ADD,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V1w ) )
      = ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V0v ) @ ( c_2Ewords_2Eword__2comp @ A_27a @ V1w ) ) ) ).

thf(thm_2Ewords_2EWORD__NEG__NEG,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V0w ) )
      = V0w ) ).

thf(thm_2Ewords_2EWORD__SUB__LNEG,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__sub @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V0v ) @ V1w )
      = ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V1w ) ) ) ).

thf(thm_2Ewords_2EWORD__SUB__RNEG,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__sub @ A_27a @ V0v @ ( c_2Ewords_2Eword__2comp @ A_27a @ V1w ) )
      = ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V1w ) ) ).

thf(thm_2Ewords_2EWORD__SUB__SUB,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__sub @ A_27a @ V0v @ ( c_2Ewords_2Eword__sub @ A_27a @ V1w @ V2x ) )
      = ( c_2Ewords_2Eword__sub @ A_27a @ ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V2x ) @ V1w ) ) ).

thf(thm_2Ewords_2EWORD__SUB__SUB2,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__sub @ A_27a @ V0v @ ( c_2Ewords_2Eword__sub @ A_27a @ V0v @ V1w ) )
      = V1w ) ).

thf(thm_2Ewords_2EWORD__EQ__SUB__LADD,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( V0v
        = ( c_2Ewords_2Eword__sub @ A_27a @ V1w @ V2x ) )
    <=> ( ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V2x )
        = V1w ) ) ).

thf(thm_2Ewords_2EWORD__EQ__SUB__RADD,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__sub @ A_27a @ V0v @ V1w )
        = V2x )
    <=> ( V0v
        = ( c_2Ewords_2Eword__add @ A_27a @ V2x @ V1w ) ) ) ).

thf(thm_2Ewords_2EWORD__EQ__SUB__ZERO,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1v: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__sub @ A_27a @ V1v @ V0w )
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
    <=> ( V1v = V0w ) ) ).

thf(thm_2Ewords_2EWORD__LCANCEL__SUB,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__sub @ A_27a @ V0v @ V1w )
        = ( c_2Ewords_2Eword__sub @ A_27a @ V2x @ V1w ) )
    <=> ( V0v = V2x ) ) ).

thf(thm_2Ewords_2EWORD__RCANCEL__SUB,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__sub @ A_27a @ V0v @ V1w )
        = ( c_2Ewords_2Eword__sub @ A_27a @ V0v @ V2x ) )
    <=> ( V1w = V2x ) ) ).

thf(thm_2Ewords_2EWORD__SUB__PLUS,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__sub @ A_27a @ V0v @ ( c_2Ewords_2Eword__add @ A_27a @ V1w @ V2x ) )
      = ( c_2Ewords_2Eword__sub @ A_27a @ ( c_2Ewords_2Eword__sub @ A_27a @ V0v @ V1w ) @ V2x ) ) ).

thf(thm_2Ewords_2EWORD__SUB__LZERO,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__sub @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) @ V0w )
      = ( c_2Ewords_2Eword__2comp @ A_27a @ V0w ) ) ).

thf(thm_2Ewords_2EWORD__SUB__RZERO,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__sub @ A_27a @ V0w @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
      = V0w ) ).

thf(thm_2Ewords_2EWORD__ADD__LID__UNIQ,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V1w )
        = V1w )
    <=> ( V0v
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ewords_2EWORD__ADD__RID__UNIQ,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V1w )
        = V0v )
    <=> ( V1w
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ewords_2EWORD__SUM__ZERO,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__add @ A_27a @ V0a @ V1b )
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
    <=> ( V0a
        = ( c_2Ewords_2Eword__2comp @ A_27a @ V1b ) ) ) ).

thf(thm_2Ewords_2EWORD__ADD__SUB2,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__sub @ A_27a @ ( c_2Ewords_2Eword__add @ A_27a @ V1w @ V0v ) @ V1w )
      = V0v ) ).

thf(thm_2Ewords_2EWORD__ADD__SUB3,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__sub @ A_27a @ V0v @ ( c_2Ewords_2Eword__add @ A_27a @ V0v @ V1x ) )
      = ( c_2Ewords_2Eword__2comp @ A_27a @ V1x ) ) ).

thf(thm_2Ewords_2EWORD__SUB__SUB3,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1v: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__sub @ A_27a @ ( c_2Ewords_2Eword__sub @ A_27a @ V1v @ V0w ) @ V1v )
      = ( c_2Ewords_2Eword__2comp @ A_27a @ V0w ) ) ).

thf(thm_2Ewords_2EWORD__EQ__NEG,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__2comp @ A_27a @ V0v )
        = ( c_2Ewords_2Eword__2comp @ A_27a @ V1w ) )
    <=> ( V0v = V1w ) ) ).

thf(thm_2Ewords_2EWORD__NEG__EQ,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1v: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__2comp @ A_27a @ V1v )
        = V0w )
    <=> ( V1v
        = ( c_2Ewords_2Eword__2comp @ A_27a @ V0w ) ) ) ).

thf(thm_2Ewords_2EWORD__NEG__EQ__0,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( ( c_2Ewords_2Eword__2comp @ A_27a @ V0v )
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
    <=> ( V0v
        = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ewords_2EWORD__SUB,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V1w ) @ V0v )
      = ( c_2Ewords_2Eword__sub @ A_27a @ V0v @ V1w ) ) ).

thf(thm_2Ewords_2EWORD__SUB__NEG,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__sub @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V0v ) @ ( c_2Ewords_2Eword__2comp @ A_27a @ V1w ) )
      = ( c_2Ewords_2Eword__sub @ A_27a @ V1w @ V0v ) ) ).

thf(thm_2Ewords_2EWORD__NEG__SUB,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a,V1v: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2Eword__sub @ A_27a @ V1v @ V0w ) )
      = ( c_2Ewords_2Eword__sub @ A_27a @ V0w @ V1v ) ) ).

thf(thm_2Ewords_2EWORD__SUB__TRIANGLE,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2Eword__sub @ A_27a @ V0v @ V1w ) @ ( c_2Ewords_2Eword__sub @ A_27a @ V1w @ V2x ) )
      = ( c_2Ewords_2Eword__sub @ A_27a @ V0v @ V2x ) ) ).

thf(thm_2Ewords_2EWORD__NOT__0,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) )
      = ( c_2Ewords_2Eword__T @ A_27a ) ) ).

thf(thm_2Ewords_2EWORD__NOT__T,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__1comp @ A_27a @ ( c_2Ewords_2Eword__T @ A_27a ) )
      = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ).

thf(thm_2Ewords_2EWORD__NEG__T,axiom,
    ! [A_27a: $tType] :
      ( ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2Eword__T @ A_27a ) )
      = ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Ewords_2EWORD__MULT__SUC,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2E_2B @ V1n @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
      = ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ ( c_2Ewords_2En2w @ A_27a @ V1n ) ) @ V0v ) ) ).

thf(thm_2Ewords_2EWORD__NEG__LMUL,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ V1w ) )
      = ( c_2Ewords_2Eword__mul @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V0v ) @ V1w ) ) ).

thf(thm_2Ewords_2EWORD__NEG__RMUL,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ V1w ) )
      = ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ ( c_2Ewords_2Eword__2comp @ A_27a @ V1w ) ) ) ).

thf(thm_2Ewords_2EWORD__NEG__MUL,axiom,
    ! [A_27a: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__2comp @ A_27a @ V0w )
      = ( c_2Ewords_2Eword__mul @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ V0w ) ) ).

thf(thm_2Ewords_2Esw2sw__w2w__add,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0w: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Esw2sw @ A_27a @ A_27b @ V0w )
      = ( c_2Ewords_2Eword__add @ A_27b @ ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27b ) @ ( c_2Ewords_2Eword__msb @ A_27a @ V0w ) @ ( c_2Ewords_2Eword__lsl @ A_27b @ ( c_2Ewords_2Eword__2comp @ A_27b @ ( c_2Ewords_2En2w @ A_27b @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) ) @ ( c_2Ewords_2En2w @ A_27b @ c_2Enum_2E0 ) ) @ ( c_2Ewords_2Ew2w @ A_27a @ A_27b @ V0w ) ) ) ).

thf(thm_2Ewords_2EWORD__ADD__BIT0,axiom,
    ! [A_27a: $tType,V0a: tyop_2Efcp_2Ecart @ $o @ A_27a,V1b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Efcp_2Efcp__index @ $o @ A_27a @ ( c_2Ewords_2Eword__add @ A_27a @ V0a @ V1b ) @ c_2Enum_2E0 )
    <=> ( (~)
        @ ( ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V0a @ c_2Enum_2E0 )
          = ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V1b @ c_2Enum_2E0 ) ) ) ) ).

thf(thm_2Ewords_2EWORD__ADD__BIT,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum,V1a: tyop_2Efcp_2Ecart @ $o @ A_27a,V2b: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Eprim__rec_2E_3C @ V0n @ ( c_2Efcp_2Edimindex @ A_27a @ ( c_2Ebool_2Ethe__value @ A_27a ) ) )
     => ( ( c_2Efcp_2Efcp__index @ $o @ A_27a @ ( c_2Ewords_2Eword__add @ A_27a @ V1a @ V2b ) @ V0n )
        = ( c_2Ebool_2ECOND @ $o @ ( c_2Emin_2E_3D @ tyop_2Enum_2Enum @ V0n @ c_2Enum_2E0 ) @ ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ $o @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V1a @ c_2Enum_2E0 ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V2b @ c_2Enum_2E0 ) ) ) @ ( c_2Ebool_2ECOND @ $o @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2Eword__bits @ A_27a @ ( c_2Earithmetic_2E_2D @ V0n @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ c_2Enum_2E0 @ V1a ) @ ( c_2Ewords_2Eword__bits @ A_27a @ ( c_2Earithmetic_2E_2D @ V0n @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ c_2Enum_2E0 @ V2b ) ) @ V0n ) @ ( c_2Emin_2E_3D @ $o @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V1a @ V0n ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V2b @ V0n ) ) @ ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ $o @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V1a @ V0n ) @ ( c_2Efcp_2Efcp__index @ $o @ A_27a @ V2b @ V0n ) ) ) ) ) ) ) ).

thf(thm_2Ewords_2EWORD__LEFT__SUB__DISTRIB,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ ( c_2Ewords_2Eword__sub @ A_27a @ V1w @ V2x ) )
      = ( c_2Ewords_2Eword__sub @ A_27a @ ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ V1w ) @ ( c_2Ewords_2Eword__mul @ A_27a @ V0v @ V2x ) ) ) ).

thf(thm_2Ewords_2EWORD__RIGHT__SUB__DISTRIB,axiom,
    ! [A_27a: $tType,V0v: tyop_2Efcp_2Ecart @ $o @ A_27a,V1w: tyop_2Efcp_2Ecart @ $o @ A_27a,V2x: tyop_2Efcp_2Ecart @ $o @ A_27a] :
      ( ( c_2Ewords_2Eword__mul @ A_27a @ ( c_2Ewords_2Eword__sub @ A_27a @ V1w @ V2x ) @ V0v )
      = ( c_2Ewords_2Eword__sub @ A_27a @ ( c_2Ewords_2Eword__mul @ A_27a @ V1w @ V0v ) @ ( c_2Ewords_2Eword__mul @ A_27a @ V2x @ V0v ) ) ) ).

thf(thm_2Ewords_2EWORD__LITERAL__MULT,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ! [V0m: tyop_2Enum_2Enum,V1n: tyop_2Enum_2Enum] :
          ( ( c_2Ewords_2Eword__mul @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0m ) @ ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V1n ) ) )
          = ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2E_2A @ V0m @ V1n ) ) ) )
      & ! [V2m: tyop_2Enum_2Enum,V3n: tyop_2Enum_2Enum] :
          ( ( c_2Ewords_2Eword__mul @ A_27b @ ( c_2Ewords_2Eword__2comp @ A_27b @ ( c_2Ewords_2En2w @ A_27b @ V2m ) ) @ ( c_2Ewords_2Eword__2comp @ A_27b @ ( c_2Ewords_2En2w @ A_27b @ V3n ) ) )
          = ( c_2Ewords_2En2w @ A_27b @ ( c_2Earithmetic_2E_2A @ V2m @ V3n ) ) ) ) ).

thf(thm_2Ewords_2EWORD__LITERAL__ADD,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ! [V0m: tyop_2Enum_2Enum,V1n: tyop_2Enum_2Enum] :
          ( ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0m ) ) @ ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V1n ) ) )
          = ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2E_2B @ V0m @ V1n ) ) ) )
      & ! [V2m: tyop_2Enum_2Enum,V3n: tyop_2Enum_2Enum] :
          ( ( c_2Ewords_2Eword__add @ A_27b @ ( c_2Ewords_2En2w @ A_27b @ V2m ) @ ( c_2Ewords_2Eword__2comp @ A_27b @ ( c_2Ewords_2En2w @ A_27b @ V3n ) ) )
          = ( c_2Ebool_2ECOND @ ( tyop_2Efcp_2Ecart @ $o @ A_27b ) @ ( c_2Earithmetic_2E_3C_3D @ V3n @ V2m ) @ ( c_2Ewords_2En2w @ A_27b @ ( c_2Earithmetic_2E_2D @ V2m @ V3n ) ) @ ( c_2Ewords_2Eword__2comp @ A_27b @ ( c_2Ewords_2En2w @ A_27b @ ( c_2Earithmetic_2E_2D @ V3n @ V2m ) ) ) ) ) ) ).

thf(thm_2Ewords_2EWORD__SUB__INTRO,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ! [V0x: tyop_2Efcp_2Ecart @ $o @ A_27a,V1y: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V1y ) @ V0x )
          = ( c_2Ewords_2Eword__sub @ A_27a @ V0x @ V1y ) )
      & ! [V2x: tyop_2Efcp_2Ecart @ $o @ A_27a,V3y: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__add @ A_27a @ V2x @ ( c_2Ewords_2Eword__2comp @ A_27a @ V3y ) )
          = ( c_2Ewords_2Eword__sub @ A_27a @ V2x @ V3y ) )
      & ! [V4x: tyop_2Efcp_2Ecart @ $o @ A_27a,V5y: tyop_2Efcp_2Ecart @ $o @ A_27a,V6z: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2Eword__mul @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V4x ) @ V5y ) @ V6z )
          = ( c_2Ewords_2Eword__sub @ A_27a @ V6z @ ( c_2Ewords_2Eword__mul @ A_27a @ V4x @ V5y ) ) )
      & ! [V7x: tyop_2Efcp_2Ecart @ $o @ A_27a,V8y: tyop_2Efcp_2Ecart @ $o @ A_27a,V9z: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__add @ A_27a @ V9z @ ( c_2Ewords_2Eword__mul @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V7x ) @ V8y ) )
          = ( c_2Ewords_2Eword__sub @ A_27a @ V9z @ ( c_2Ewords_2Eword__mul @ A_27a @ V7x @ V8y ) ) )
      & ! [V10x: tyop_2Efcp_2Ecart @ $o @ A_27b] :
          ( ( c_2Ewords_2Eword__mul @ A_27b @ ( c_2Ewords_2Eword__2comp @ A_27b @ ( c_2Ewords_2En2w @ A_27b @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ V10x )
          = ( c_2Ewords_2Eword__2comp @ A_27b @ V10x ) )
      & ! [V11x: tyop_2Efcp_2Ecart @ $o @ A_27a,V12y: tyop_2Efcp_2Ecart @ $o @ A_27a,V13z: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__sub @ A_27a @ V13z @ ( c_2Ewords_2Eword__mul @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V11x ) @ V12y ) )
          = ( c_2Ewords_2Eword__add @ A_27a @ V13z @ ( c_2Ewords_2Eword__mul @ A_27a @ V11x @ V12y ) ) )
      & ! [V14x: tyop_2Efcp_2Ecart @ $o @ A_27a,V15y: tyop_2Efcp_2Ecart @ $o @ A_27a,V16z: tyop_2Efcp_2Ecart @ $o @ A_27a] :
          ( ( c_2Ewords_2Eword__sub @ A_27a @ ( c_2Ewords_2Eword__mul @ A_27a @ ( c_2Ewords_2Eword__2comp @ A_27a @ V14x ) @ V15y ) @ V16z )
          = ( c_2Ewords_2Eword__2comp @ A_27a @ ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2Eword__mul @ A_27a @ V14x @ V15y ) @ V16z ) ) ) ) ).

thf(thm_2Ewords_2En2w__SUC,axiom,
    ! [A_27a: $tType,V0n: tyop_2Enum_2Enum] :
      ( ( c_2Ewords_2En2w @ A_27a @ ( c_2Enum_2ESUC @ V0n ) )
      = ( c_2Ewords_2Eword__add @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0n ) @ ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Ewords_2En2w__sub,conjecture,
    ! [A_27a: $tType,V0a: tyop_2Enum_2Enum,V1b: tyop_2Enum_2Enum] :
      ( ( c_2Earithmetic_2E_3C_3D @ V1b @ V0a )
     => ( ( c_2Ewords_2En2w @ A_27a @ ( c_2Earithmetic_2E_2D @ V0a @ V1b ) )
        = ( c_2Ewords_2Eword__sub @ A_27a @ ( c_2Ewords_2En2w @ A_27a @ V0a ) @ ( c_2Ewords_2En2w @ A_27a @ V1b ) ) ) ) ).

%------------------------------------------------------------------------------
